/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.level;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.FeatureHooks;
import io.papermc.paper.world.PaperWorldLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Main;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.CatSpawner;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.generator.Generator;
import net.thenextlvl.worlds.api.generator.LevelStem;
import net.thenextlvl.worlds.api.preset.Presets;
import net.thenextlvl.worlds.level.LevelData;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.generator.CraftWorldInfo;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.persistence.PersistentDataType;
import org.jspecify.annotations.NullMarked;

@NullMarked
class PaperLevel
extends LevelData {
    public PaperLevel(WorldsPlugin plugin, LevelData.Builder builder) {
        super(plugin, builder);
    }

    @Override
    public CompletableFuture<World> createAsync() {
        return this.plugin.supplyGlobal(this::createInternal);
    }

    private CompletableFuture<World> createInternal() {
        String levelName;
        PrimaryLevelData primaryLevelData;
        LevelStorageSource.LevelStorageAccess levelStorageAccess;
        CraftServer server = (CraftServer)this.plugin.getServer();
        DedicatedServer console = server.getServer();
        try {
            Preconditions.checkState((boolean)console.getAllLevels().iterator().hasNext(), (Object)"Cannot create worlds before main level is created");
            Preconditions.checkArgument((!Files.exists(this.directory, new LinkOption[0]) || Files.isDirectory(this.directory, new LinkOption[0]) ? 1 : 0) != 0, (String)"File (%s) exists and isn't a folder", (Object)this.directory);
            Preconditions.checkArgument((server.getWorld(this.key) == null ? 1 : 0) != 0, (String)"World with key %s already exists", (Object)this.key);
            Preconditions.checkArgument((server.getWorld(this.name) == null ? 1 : 0) != 0, (String)"World with name %s already exists", (Object)this.name);
            Preconditions.checkState((boolean)this.plugin.getServer().getWorlds().stream().map(World::getWorldFolder).map(File::toPath).noneMatch(this.directory::equals), (String)"World with directory %s already exists", (Object)this.directory);
        }
        catch (RuntimeException e) {
            return CompletableFuture.failedFuture(e);
        }
        ChunkGenerator chunkGenerator = Optional.ofNullable(this.chunkGenerator).orElseGet(() -> Optional.ofNullable(this.generator).map(generator -> generator.generator(this.name)).orElseGet(() -> server.getGenerator(this.name)));
        BiomeProvider biomeProvider = Optional.ofNullable(this.biomeProvider).orElseGet(() -> Optional.ofNullable(this.generator).map(generator -> generator.biomeProvider(this.name)).orElseGet(() -> server.getBiomeProvider(this.name)));
        ResourceKey<net.minecraft.world.level.dimension.LevelStem> dimensionType = this.resolveDimensionKey();
        try {
            levelStorageAccess = LevelStorageSource.createDefault((Path)server.getWorldContainer().toPath()).validateAndCreateAccess(this.directory.getFileName().toString(), dimensionType);
        }
        catch (IOException | ContentValidationException ex) {
            return CompletableFuture.failedFuture(ex);
        }
        WorldLoader.DataLoadContext context = console.worldLoaderContext;
        RegistryAccess.Frozen registryAccess = context.datapackDimensions();
        Registry contextLevelStemRegistry = registryAccess.lookupOrThrow(Registries.LEVEL_STEM);
        PaperWorldLoader.LevelDataResult levelData = PaperWorldLoader.getLevelData((LevelStorageSource.LevelStorageAccess)levelStorageAccess);
        if (levelData.fatalError()) {
            return CompletableFuture.failedFuture(new IOException("Failed to read level data"));
        }
        Dynamic dataTag = levelData.dataTag();
        if (dataTag != null) {
            LevelDataAndDimensions levelDataAndDimensions = LevelStorageSource.getLevelDataAndDimensions((Dynamic)dataTag, (WorldDataConfiguration)context.dataConfiguration(), (Registry)contextLevelStemRegistry, (HolderLookup.Provider)context.datapackWorldgen());
            primaryLevelData = (PrimaryLevelData)levelDataAndDimensions.worldData();
            registryAccess = levelDataAndDimensions.dimensions().dimensionsRegistryAccess();
        } else {
            WorldOptions worldOptions = new WorldOptions(this.seed, this.structures, this.bonusChest);
            JsonObject generatorSettings = Optional.ofNullable(this.preset).orElse(Presets.CLASSIC_FLAT).serialize();
            DedicatedServerProperties.WorldDimensionData properties = new DedicatedServerProperties.WorldDimensionData(generatorSettings, this.generatorType.presetName().asString());
            LevelSettings levelSettings = new LevelSettings(this.name, GameType.byId((int)server.getDefaultGameMode().getValue()), this.hardcore, Difficulty.EASY, false, new GameRules(context.dataConfiguration().enabledFeatures()), context.dataConfiguration());
            WorldDimensions worldDimensions = properties.create(context.datapackWorldgen());
            WorldDimensions.Complete complete = worldDimensions.bake(contextLevelStemRegistry);
            Lifecycle lifecycle = complete.lifecycle().add(context.datapackWorldgen().allRegistriesLifecycle());
            primaryLevelData = new PrimaryLevelData(levelSettings, worldOptions, complete.specialWorldProperty(), lifecycle);
            registryAccess = complete.dimensionsRegistryAccess();
        }
        primaryLevelData.customDimensions = contextLevelStemRegistry = registryAccess.lookupOrThrow(Registries.LEVEL_STEM);
        primaryLevelData.checkName(this.name);
        primaryLevelData.setModdedInfo(console.getServerModName(), console.getModdedStatus().shouldReportAsModified());
        if (console.options.has("forceUpgrade")) {
            Main.forceUpgrade((LevelStorageSource.LevelStorageAccess)levelStorageAccess, (WorldData)primaryLevelData, (DataFixer)DataFixers.getDataFixer(), (boolean)console.options.has("eraseCache"), () -> true, (RegistryAccess)registryAccess, (boolean)console.options.has("recreateRegionFiles"));
        }
        long seed = BiomeManager.obfuscateSeed((long)primaryLevelData.worldGenOptions().seed());
        ImmutableList list = ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner((ServerLevelData)primaryLevelData));
        net.minecraft.world.level.dimension.LevelStem customStem = (net.minecraft.world.level.dimension.LevelStem)contextLevelStemRegistry.getValueOrThrow(dimensionType);
        CraftWorldInfo worldInfo = new CraftWorldInfo(primaryLevelData, levelStorageAccess, this.toBukkit(this.levelStem.dimensionType()), (DimensionType)customStem.type().value(), customStem.generator(), server.getHandle().getServer().registryAccess());
        if (biomeProvider == null && chunkGenerator != null) {
            biomeProvider = chunkGenerator.getDefaultBiomeProvider((WorldInfo)worldInfo);
        }
        ResourceKey dimensionKey = this.name.equals((levelName = server.getServer().getProperties().levelName) + "_nether") ? Level.NETHER : (this.name.equals(levelName + "_the_end") ? Level.END : ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.key.namespace(), (String)this.key.value())));
        ServerLevel serverLevel = new ServerLevel((MinecraftServer)console, console.executor, levelStorageAccess, primaryLevelData, dimensionKey, customStem, primaryLevelData.isDebugWorld(), seed, (List)(this.levelStem == LevelStem.OVERWORLD ? list : ImmutableList.of()), true, console.overworld().getRandomSequences(), this.toBukkit(this.levelStem.dimensionType()), chunkGenerator, biomeProvider);
        if (server.getWorld(this.name) == null) {
            return CompletableFuture.failedFuture(new IllegalStateException("World with name " + this.name + " was not properly memoized"));
        }
        console.addLevel(serverLevel);
        CompletableFuture<World> future = new CompletableFuture<World>();
        if (!WorldsPlugin.RUNNING_FOLIA) {
            console.initWorld(serverLevel, primaryLevelData, primaryLevelData.worldGenOptions());
        }
        serverLevel.setSpawnSettings(true);
        this.persistWorld((World)serverLevel.getWorld(), this.levelStem, this.enabled.toBooleanOrElse(true));
        if (this.generator != null) {
            this.persistGenerator((World)serverLevel.getWorld(), this.generator);
        }
        FeatureHooks.tickEntityManager((ServerLevel)serverLevel);
        console.prepareLevel(serverLevel);
        if (!WorldsPlugin.RUNNING_FOLIA) {
            future.complete((World)serverLevel.getWorld());
        }
        return future;
    }

    public void persistWorld(World world, LevelStem dimension, boolean enabled) {
        NamespacedKey worldKey = new NamespacedKey("worlds", "world_key");
        NamespacedKey dimensionKey = new NamespacedKey("worlds", "dimension");
        world.getPersistentDataContainer().set(worldKey, PersistentDataType.STRING, (Object)world.key().asString());
        world.getPersistentDataContainer().set(dimensionKey, PersistentDataType.STRING, (Object)dimension.dimensionType().key().asString());
        this.plugin.levelView().setEnabled(world, enabled);
    }

    public void persistGenerator(World world, Generator generator) {
        NamespacedKey generatorKey = new NamespacedKey("worlds", "generator");
        world.getPersistentDataContainer().set(generatorKey, PersistentDataType.STRING, (Object)generator.asString());
    }

    private ResourceKey<net.minecraft.world.level.dimension.LevelStem> resolveDimensionKey() {
        if (this.getLevelStem().equals(LevelStem.OVERWORLD)) {
            return net.minecraft.world.level.dimension.LevelStem.OVERWORLD;
        }
        if (this.getLevelStem().equals(LevelStem.NETHER)) {
            return net.minecraft.world.level.dimension.LevelStem.NETHER;
        }
        if (this.getLevelStem().equals(LevelStem.END)) {
            return net.minecraft.world.level.dimension.LevelStem.END;
        }
        throw new IllegalArgumentException("Illegal dimension (" + String.valueOf(this.getLevelStem()) + ")");
    }

    private World.Environment toBukkit(net.thenextlvl.worlds.api.generator.DimensionType type) {
        if (type.equals(net.thenextlvl.worlds.api.generator.DimensionType.OVERWORLD)) {
            return World.Environment.NORMAL;
        }
        if (type.equals(net.thenextlvl.worlds.api.generator.DimensionType.THE_NETHER)) {
            return World.Environment.NETHER;
        }
        if (type.equals(net.thenextlvl.worlds.api.generator.DimensionType.THE_END)) {
            return World.Environment.THE_END;
        }
        return World.Environment.CUSTOM;
    }
}

