/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.tag;

import java.util.ArrayList;
import java.util.List;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.nbt.tag.ValueTag;
import net.thenextlvl.nbt.tag.impl.ListTagImpl;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;

@NullMarked
public sealed interface ListTag<V extends Tag>
extends ValueTag<List<V>>,
List<V>
permits ListTagImpl {
    public static final int ID = 9;

    @Contract(pure=true)
    public int getContentTypeId();

    @SafeVarargs
    @Contract(value="_, _ -> new", pure=true)
    public static <V extends Tag> ListTag<V> of(int contentTypeId, V ... content) throws IllegalArgumentException {
        return ListTag.of(contentTypeId, new ArrayList<V>(List.of(content)));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <V extends Tag> ListTag<V> of(int contentTypeId, List<V> content) throws IllegalArgumentException {
        return new ListTagImpl<V>(content, contentTypeId);
    }

    @SafeVarargs
    @Contract(value="_ -> new", pure=true)
    public static <V extends Tag> ListTag<V> of(V ... content) throws IllegalArgumentException {
        return ListTag.of(new ArrayList<V>(List.of(content)));
    }

    @Contract(value="_ -> new", pure=true)
    public static <V extends Tag> ListTag<V> of(List<V> content) throws IllegalArgumentException {
        return new ListTagImpl<V>(content);
    }
}

