/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.tag;

import java.io.IOException;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.ListTag;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface Tag {
    @Contract(pure=true)
    public int getTypeId();

    @Contract(mutates="param1")
    public void write(NBTOutputStream var1) throws IOException;

    @Contract(pure=true)
    default public boolean isCompound() {
        return false;
    }

    @Contract(pure=true)
    default public boolean isList() {
        return false;
    }

    @Contract(pure=true)
    default public boolean isNumber() {
        return false;
    }

    @Contract(pure=true)
    default public boolean isBoolean() {
        return this.isNumber();
    }

    @Contract(pure=true)
    default public boolean isString() {
        return false;
    }

    @Contract(value=" -> this", pure=true)
    default public CompoundTag getAsCompound() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    @Contract(value=" -> this", pure=true)
    default public <V extends Tag> ListTag<V> getAsList() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    @Contract(pure=true)
    default public Number getAsNumber() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    @Contract(pure=true)
    default public String getAsString() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    @Contract(pure=true)
    default public boolean getAsBoolean() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    @Contract(pure=true)
    default public double getAsDouble() throws UnsupportedOperationException {
        return this.getAsNumber().doubleValue();
    }

    @Contract(pure=true)
    default public float getAsFloat() throws UnsupportedOperationException {
        return this.getAsNumber().floatValue();
    }

    @Contract(pure=true)
    default public long getAsLong() throws UnsupportedOperationException {
        return this.getAsNumber().longValue();
    }

    @Contract(pure=true)
    default public int getAsInt() throws UnsupportedOperationException {
        return this.getAsNumber().intValue();
    }

    @Contract(pure=true)
    default public byte getAsByte() throws UnsupportedOperationException {
        return this.getAsNumber().byteValue();
    }

    @Contract(pure=true)
    default public short getAsShort() throws UnsupportedOperationException {
        return this.getAsNumber().shortValue();
    }
}

