/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.FinePositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.EntitySelectorArgumentResolver;
import io.papermc.paper.math.FinePosition;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.command.WorldCommand;
import net.thenextlvl.worlds.command.brigadier.SimpleCommand;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldTeleportCommand
extends SimpleCommand {
    WorldTeleportCommand(WorldsPlugin plugin) {
        super(plugin, "teleport", "worlds.command.teleport");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldTeleportCommand command = new WorldTeleportCommand(plugin);
        return command.create().then(((RequiredArgumentBuilder)WorldCommand.worldArgument(plugin).then(command.teleportEntity())).executes((Command)command));
    }

    private RequiredArgumentBuilder<CommandSourceStack, EntitySelectorArgumentResolver> teleportEntity() {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"entities", (ArgumentType)ArgumentTypes.entities()).then(Commands.argument((String)"position", (ArgumentType)ArgumentTypes.finePosition((boolean)true)).executes((Command)this))).executes((Command)this);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        EntitySelectorArgumentResolver entityResolver = this.tryGetArgument(context, "entities", EntitySelectorArgumentResolver.class).orElse(null);
        if (entityResolver == null) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
            } else {
                this.plugin.bundle().sendMessage((Audience)sender, "command.sender");
                return 0;
            }
        }
        FinePositionResolver position = this.tryGetArgument(context, "position", FinePositionResolver.class).orElse(null);
        World world = (World)context.getArgument("world", World.class);
        List entities = entityResolver != null ? (List)entityResolver.resolve((CommandSourceStack)context.getSource()) : List.of((Player)sender);
        Location location = position != null ? ((FinePosition)position.resolve((CommandSourceStack)context.getSource())).toLocation(world) : world.getSpawnLocation();
        entities.forEach(entity -> entity.teleportAsync(location, PlayerTeleportEvent.TeleportCause.COMMAND).thenRun(() -> this.plugin.bundle().sendMessage((Audience)entity, "world.teleport.self", new TagResolver[]{Placeholder.parsed((String)"world", (String)location.getWorld().getName())})));
        if (entities.size() == 1 && ((Entity)entities.getFirst()).equals((Object)sender)) {
            return 1;
        }
        String message = entities.size() == 1 ? "world.teleport.other" : (entities.isEmpty() ? "world.teleport.none" : "world.teleport.others");
        Entity entity2 = entities.isEmpty() ? null : (Entity)entities.getFirst();
        Runnable runnable = () -> this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.component((String)"entity", (ComponentLike)(entity2 != null ? entity2.name() : Component.empty())), Placeholder.parsed((String)"entities", (String)String.valueOf(entities.size())), Placeholder.parsed((String)"world", (String)location.getWorld().getName())});
        if (entity2 != null) {
            entity2.getScheduler().run((Plugin)this.plugin, task -> runnable.run(), null);
        } else {
            runnable.run();
        }
        return entities.isEmpty() ? 0 : 1;
    }
}

