/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command.link;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.command.WorldCommand;
import net.thenextlvl.worlds.command.argument.KeyArgument;
import net.thenextlvl.worlds.command.brigadier.SimpleCommand;
import net.thenextlvl.worlds.command.suggestion.LinkSuggestionProvider;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldLinkRemoveCommand
extends SimpleCommand {
    private WorldLinkRemoveCommand(WorldsPlugin plugin) {
        super(plugin, "remove", "worlds.command.link.remove");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldLinkRemoveCommand command = new WorldLinkRemoveCommand(plugin);
        return command.create().then(command.remove());
    }

    private RequiredArgumentBuilder<CommandSourceStack, World> remove() {
        return (RequiredArgumentBuilder)WorldCommand.worldArgument(this.plugin).suggests(new LinkSuggestionProvider(this.plugin, true)).then(Commands.argument((String)"destination", (ArgumentType)new KeyArgument()).suggests(new LinkSuggestionProvider.Linked(this.plugin)).executes((Command)this));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        World world = (World)context.getArgument("world", World.class);
        Key destination = (Key)context.getArgument("destination", Key.class);
        boolean removed = this.plugin.linkProvider().unlink(world.key(), destination);
        String message = removed ? "world.unlink.success" : "world.unlink.failed";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.parsed((String)"relative", (String)destination.key().asString()), Placeholder.parsed((String)"world", (String)world.getName())});
        return removed ? 1 : 0;
    }
}

