/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.link;

import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.thenextlvl.worlds.api.link.LinkTree;
import net.thenextlvl.worlds.link.WorldLinkProvider;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class WorldLinkTree
implements LinkTree {
    public static final NamespacedKey LINK_NETHER = new NamespacedKey("worlds", "link_nether");
    public static final NamespacedKey LINK_END = new NamespacedKey("worlds", "link_end");
    private final WorldLinkProvider provider;
    private final World overworld;
    private @Nullable Key nether = null;
    private @Nullable Key end = null;

    public WorldLinkTree(WorldLinkProvider provider, World overworld) {
        this.provider = provider;
        this.overworld = overworld;
    }

    @Override
    public World getOverworld() {
        return this.overworld;
    }

    @Override
    public Optional<World> getNether() {
        return this.getPersistedNether().map(arg_0 -> ((Server)this.provider.getServer()).getWorld(arg_0));
    }

    @Override
    public Optional<Key> getPersistedNether() {
        return Optional.ofNullable(this.nether);
    }

    @Override
    public boolean setNether(@Nullable World world) {
        if (world != null && !world.getEnvironment().equals((Object)World.Environment.NETHER)) {
            return false;
        }
        return this.setNether(world != null ? world.key() : null);
    }

    boolean setNether(@Nullable Key key) {
        if (key != null && this.getLinkProvider().hasLinkTree(key)) {
            return false;
        }
        this.nether = key;
        return true;
    }

    @Override
    public Optional<World> getEnd() {
        return this.getPersistedEnd().map(arg_0 -> ((Server)this.provider.getServer()).getWorld(arg_0));
    }

    @Override
    public Optional<Key> getPersistedEnd() {
        return Optional.ofNullable(this.end);
    }

    @Override
    public boolean setEnd(@Nullable World world) {
        if (world != null && !world.getEnvironment().equals((Object)World.Environment.THE_END)) {
            return false;
        }
        return this.setEnd(world != null ? world.key() : null);
    }

    @Override
    public boolean isEmpty() {
        return this.nether == null && this.end == null;
    }

    boolean setEnd(@Nullable Key key) {
        if (key != null && this.getLinkProvider().hasLinkTree(key)) {
            return false;
        }
        this.end = key;
        return true;
    }

    @Override
    public boolean contains(Key key) {
        return key.equals((Object)this.overworld.key()) || key.equals((Object)this.nether) || key.equals((Object)this.end);
    }

    @Override
    public boolean contains(World world) {
        return this.contains(world.key());
    }

    @Override
    public boolean remove(Key key) {
        if (key.equals((Object)this.end)) {
            this.end = null;
            return true;
        }
        if (key.equals((Object)this.nether)) {
            this.nether = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(World world) {
        return this.remove(world.key());
    }

    @Override
    public Optional<World> getWorld(World.Environment environment) {
        return switch (environment) {
            case World.Environment.NORMAL -> Optional.of(this.getOverworld());
            case World.Environment.NETHER -> this.getNether();
            case World.Environment.THE_END -> this.getEnd();
            default -> Optional.empty();
        };
    }

    @Override
    public WorldLinkProvider getLinkProvider() {
        return this.provider;
    }

    public String toString() {
        if (this.nether == null && this.end == null) {
            return this.overworld.key().asString();
        }
        if (this.nether == null) {
            return String.valueOf(this.overworld.key()) + " -> " + String.valueOf(this.end);
        }
        if (this.end == null) {
            return String.valueOf(this.overworld.key()) + " -> " + String.valueOf(this.nether);
        }
        return String.valueOf(this.overworld.key()) + " -> " + String.valueOf(this.nether) + " & " + String.valueOf(this.end);
    }
}

