/*
 * Decompiled with CFR 0.152.
 */
package core.file;

import core.io.IO;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class FileIO<R> {
    private final IO io;
    private Charset charset;
    private @Nullable R root;
    private boolean loaded;

    protected FileIO(@NonNull IO io, @NonNull Charset charset, @Nullable R root) {
        this.io = io;
        this.charset = charset;
        this.root = root;
    }

    protected FileIO(@NonNull IO io, @NonNull Charset charset) {
        this(io, charset, null);
    }

    protected FileIO(@NonNull IO io, R root) {
        this(io, StandardCharsets.UTF_8, root);
    }

    protected FileIO(@NonNull IO io) {
        this(io, null);
    }

    public final @NonNull FileIO<R> setRoot(R root) {
        this.loaded = true;
        this.root = root;
        return this;
    }

    public R getRoot() {
        if (this.loaded) {
            return this.root;
        }
        this.loaded = true;
        this.root = this.load();
        return this.root;
    }

    protected abstract R load();

    public abstract @NonNull FileIO<R> save(FileAttribute<?> ... var1);

    public @NonNull FileIO<R> reload() {
        return this.setRoot(this.load());
    }

    public @NonNull FileIO<R> saveIfAbsent() {
        return this.getIO().exists(new LinkOption[0]) ? this : this.save(new FileAttribute[0]);
    }

    public boolean delete() throws IOException {
        return this.getIO().delete();
    }

    public IO getIO() {
        return this.io;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public FileIO<R> setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileIO fileIO = (FileIO)o;
        return Objects.equals(this.io, fileIO.io) && Objects.equals(this.charset, fileIO.charset) && Objects.equals(this.root, fileIO.root);
    }

    public int hashCode() {
        return Objects.hash(this.io, this.charset, this.root);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{io=" + String.valueOf(this.io) + ", charset=" + String.valueOf(this.charset) + ", root=" + String.valueOf(this.root) + ", loaded=" + this.loaded + "}";
    }
}

