/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.listener;

import io.papermc.paper.event.entity.EntityPortalReadyEvent;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.feature.EndPlatformFeature;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.model.PortalCooldown;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PortalListener
implements Listener {
    private final PortalCooldown cooldown = new PortalCooldown();
    private final WorldsPlugin plugin;

    public PortalListener(WorldsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityPortal(EntityPortalReadyEvent event) {
        this.plugin.linkProvider().getTarget(event.getEntity().getWorld(), event.getPortalType()).ifPresentOrElse(arg_0 -> ((EntityPortalReadyEvent)event).setTargetWorld(arg_0), () -> event.setTargetWorld(null));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityPortalEnter(EntityPortalEnterEvent event) {
        if (!event.getPortalType().equals((Object)PortalType.ENDER)) {
            return;
        }
        event.setCancelled(true);
        if (!this.cooldown.start(this.plugin, event.getEntity())) {
            return;
        }
        EntityPortalReadyEvent readyEvent = new EntityPortalReadyEvent(event.getEntity(), null, PortalType.ENDER);
        this.onEntityPortal(readyEvent);
        World targetWorld = readyEvent.getTargetWorld();
        if (targetWorld == null) {
            return;
        }
        if (targetWorld.getEnvironment().equals((Object)World.Environment.THE_END)) {
            Location spawn = new Location(targetWorld, 100.5, 49.0, 0.5, 90.0f, 0.0f);
            this.plugin.getServer().getRegionScheduler().run((Plugin)this.plugin, spawn, scheduledTask -> {
                this.generateEndPlatform(targetWorld, event.getEntity());
                event.getEntity().teleportAsync(spawn, PlayerTeleportEvent.TeleportCause.END_PORTAL);
            });
        } else {
            Entity spawn = event.getEntity();
            if (spawn instanceof CraftPlayer) {
                CraftPlayer player = (CraftPlayer)spawn;
                Consumer<@Nullable Location> teleport = location -> player.getScheduler().run((Plugin)this.plugin, scheduledTask -> {
                    ServerLevel level = ((CraftWorld)player.getWorld()).getHandle();
                    if (WorldsPlugin.RUNNING_FOLIA || level.paperConfig().misc.disableEndCredits) {
                        player.getHandle().seenCredits = true;
                    } else if (!player.getHandle().seenCredits) {
                        player.getHandle().showEndCredits();
                    }
                    player.teleportAsync(Objects.requireNonNullElseGet(location, () -> ((World)targetWorld).getSpawnLocation()), PlayerTeleportEvent.TeleportCause.END_PORTAL);
                }, null);
                Location potentialLocation = player.getPotentialRespawnLocation();
                if (WorldsPlugin.RUNNING_FOLIA && potentialLocation != null) {
                    this.plugin.getServer().getRegionScheduler().run((Plugin)this.plugin, potentialLocation, task -> teleport.accept(player.getRespawnLocation(true)));
                } else {
                    teleport.accept(player.getRespawnLocation(true));
                }
            } else {
                event.getEntity().getScheduler().run((Plugin)this.plugin, task -> event.getEntity().teleportAsync(targetWorld.getSpawnLocation(), PlayerTeleportEvent.TeleportCause.END_PORTAL), null);
            }
        }
    }

    private void generateEndPlatform(World world, Entity entity) {
        ServerLevel handle = ((CraftWorld)world).getHandle();
        net.minecraft.world.entity.Entity entityHandle = WorldsPlugin.RUNNING_FOLIA ? null : ((CraftEntity)entity).getHandle();
        EndPlatformFeature.createEndPlatform((ServerLevelAccessor)handle, (BlockPos)new BlockPos(100, 49, 0), (boolean)true, (net.minecraft.world.entity.Entity)entityHandle);
    }
}

