/*
 * Decompiled with CFR 0.152.
 */
package core.file.format;

import core.file.FileIO;
import core.io.IO;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class TextFile
extends FileIO<List<String>> {
    public TextFile(IO io, Charset charset, List<String> root) {
        super(io, charset, root);
    }

    public TextFile(IO io, Charset charset) {
        this(io, charset, (List<String>)new ArrayList<String>());
    }

    public TextFile(IO io, List<String> root) {
        this(io, StandardCharsets.UTF_8, root);
    }

    public TextFile(IO io) {
        this(io, StandardCharsets.UTF_8);
    }

    @Override
    protected List<String> load() {
        List<String> list;
        if (!this.getIO().exists(new LinkOption[0])) {
            return (List)this.getRoot();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getIO().inputStream(StandardOpenOption.READ), this.getCharset()));
        try {
            list = reader.lines().collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return list;
    }

    public TextFile save(FileAttribute<?> ... attributes) {
        TextFile textFile;
        List root = (List)this.getRoot();
        this.getIO().createParents(attributes);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.getIO().outputStream(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), this.getCharset()));
        try {
            writer.write(String.join((CharSequence)"\n", root));
            textFile = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        writer.close();
        return textFile;
    }
}

