/*
 * Decompiled with CFR 0.152.
 */
package core.file.format.separator;

import core.file.FileIO;
import core.io.IO;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class SeparatorFile
extends FileIO<List<List<String>>> {
    protected SeparatorFile(IO io, Charset charset, List<List<String>> root) {
        super(io, charset, root);
    }

    protected SeparatorFile(IO io, Charset charset) {
        this(io, charset, (List<List<String>>)new ArrayList<List<String>>());
    }

    protected SeparatorFile(IO io, List<List<String>> root) {
        this(io, StandardCharsets.UTF_8, root);
    }

    protected SeparatorFile(IO io) {
        this(io, (List<List<String>>)new ArrayList<List<String>>());
    }

    public void insert(Object ... values) {
        ArrayList<String> insert = new ArrayList<String>();
        for (Object o : values) {
            insert.add(o.toString());
        }
        ((List)this.getRoot()).add(insert);
    }

    public boolean remove(Object ... values) {
        return ((List)this.getRoot()).removeIf(entry -> {
            for (Object object : values) {
                if (entry.contains(object.toString())) continue;
                return false;
            }
            return true;
        });
    }

    public List<List<String>> select(Object ... parameters) {
        ArrayList<List<String>> matches = new ArrayList<List<String>>();
        block0: for (List row : (List)this.getRoot()) {
            for (Object parameter : parameters) {
                if (!row.contains(parameter.toString())) continue block0;
            }
            matches.add(row);
        }
        return matches;
    }

    @Override
    protected List<List<String>> load() {
        List<List<String>> list;
        if (!this.getIO().exists(new LinkOption[0])) {
            return (List)this.getRoot();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getIO().inputStream(StandardOpenOption.READ), this.getCharset()));
        try {
            list = reader.lines().filter(s -> !s.isBlank()).map(s -> List.of(s.split(this.getDelimiter()))).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return list;
    }

    @Override
    @NullMarked
    public FileIO<List<List<String>>> save(FileAttribute<?> ... attributes) {
        SeparatorFile separatorFile;
        List root = (List)this.getRoot();
        this.getIO().createParents(attributes);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.getIO().outputStream(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), this.getCharset()));
        try {
            writer.write(String.join((CharSequence)"\n", root.stream().map(strings -> String.join((CharSequence)this.getDelimiter(), strings)).toList()));
            separatorFile = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        writer.close();
        return separatorFile;
    }

    public abstract String getDelimiter();
}

