/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.link;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.link.LinkProvider;
import net.thenextlvl.worlds.api.link.LinkTree;
import net.thenextlvl.worlds.link.WorldLinkTree;
import org.bukkit.NamespacedKey;
import org.bukkit.PortalType;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class WorldLinkProvider
implements LinkProvider {
    private static final NamespacedKey OLD_LINK_NETHER = new NamespacedKey("relative", "nether");
    private static final NamespacedKey OLD_LINK_END = new NamespacedKey("relative", "the_end");
    private final Set<LinkTree> trees = new HashSet<LinkTree>();
    private final WorldsPlugin plugin;

    public WorldLinkProvider(WorldsPlugin plugin) {
        this.plugin = plugin;
    }

    public void unloadTree(World world) {
        if (!world.getEnvironment().equals((Object)World.Environment.NORMAL)) {
            return;
        }
        this.trees.removeIf(tree -> tree.getOverworld().equals((Object)world));
    }

    public void loadTree(World world) {
        if (!world.getEnvironment().equals((Object)World.Environment.NORMAL)) {
            return;
        }
        boolean noneMatch = this.trees.stream().noneMatch(tree -> tree.getOverworld().equals((Object)world));
        Preconditions.checkState((boolean)noneMatch, (String)"World tree is already loaded for %s", (Object)world.getName());
        WorldLinkTree tree2 = new WorldLinkTree(this, world);
        PersistentDataContainer data = world.getPersistentDataContainer();
        Optional.ofNullable((String)data.get(OLD_LINK_NETHER, PersistentDataType.STRING)).map(Key::key).ifPresent(key -> {
            data.remove(OLD_LINK_NETHER);
            tree2.setNether((Key)key);
        });
        Optional.ofNullable((String)data.get(OLD_LINK_END, PersistentDataType.STRING)).map(Key::key).ifPresent(key -> {
            data.remove(OLD_LINK_END);
            tree2.setEnd((Key)key);
        });
        Optional.ofNullable((String)data.get(WorldLinkTree.LINK_NETHER, PersistentDataType.STRING)).map(Key::key).ifPresent(tree2::setNether);
        Optional.ofNullable((String)data.get(WorldLinkTree.LINK_END, PersistentDataType.STRING)).map(Key::key).ifPresent(tree2::setEnd);
        this.trees.add(tree2);
    }

    public void persistTrees() {
        this.getLinkTrees().forEach(tree -> this.persistTree(tree.getOverworld()));
    }

    public void persistTree(World world) {
        if (!world.getEnvironment().equals((Object)World.Environment.NORMAL)) {
            return;
        }
        this.getLinkTree(world).filter(linkTree -> !linkTree.isEmpty()).ifPresent(tree -> {
            PersistentDataContainer container = world.getPersistentDataContainer();
            tree.getPersistedNether().map(Key::asString).ifPresentOrElse(nether -> container.set(WorldLinkTree.LINK_NETHER, PersistentDataType.STRING, nether), () -> container.remove(WorldLinkTree.LINK_NETHER));
            tree.getPersistedEnd().map(Key::asString).ifPresentOrElse(nether -> container.set(WorldLinkTree.LINK_END, PersistentDataType.STRING, nether), () -> container.remove(WorldLinkTree.LINK_END));
        });
    }

    @Override
    public Stream<LinkTree> getLinkTrees() {
        return this.trees.stream();
    }

    @Override
    public Optional<LinkTree> getLinkTree(Key key) {
        return this.trees.stream().filter(tree -> tree.contains(key)).findAny();
    }

    @Override
    public Optional<LinkTree> getLinkTree(World world) {
        return this.getLinkTree(world.key());
    }

    @Override
    public Optional<World> getTarget(World world, PortalType type) {
        return switch (type) {
            case PortalType.NETHER -> {
                switch (world.getEnvironment()) {
                    case NORMAL: 
                    case THE_END: {
                        yield this.getLinkTree(world).flatMap(LinkTree::getNether);
                    }
                    case NETHER: {
                        yield this.getLinkTree(world).map(LinkTree::getOverworld);
                    }
                }
                yield Optional.empty();
            }
            case PortalType.ENDER -> {
                switch (world.getEnvironment()) {
                    case NORMAL: 
                    case NETHER: {
                        yield this.getLinkTree(world).flatMap(LinkTree::getEnd);
                    }
                    case THE_END: {
                        yield this.getLinkTree(world).map(LinkTree::getOverworld);
                    }
                }
                yield Optional.empty();
            }
            default -> Optional.empty();
        };
    }

    @Override
    public boolean link(World source, World target) {
        if (!source.getEnvironment().equals((Object)World.Environment.NORMAL)) {
            return false;
        }
        return this.getLinkTree(source).map(linkTree -> switch (target.getEnvironment()) {
            case World.Environment.NETHER -> linkTree.setNether(target);
            case World.Environment.THE_END -> linkTree.setEnd(target);
            default -> false;
        }).orElse(false);
    }

    @Override
    public boolean unlink(Key source, Key target) {
        return this.plugin.linkProvider().getLinkTree(source).filter(tree -> !tree.isEmpty()).map(tree -> tree.remove(target)).orElse(false);
    }

    @Override
    public boolean unlink(World source, World target) {
        return this.unlink(source.key(), target.key());
    }

    @Override
    public boolean hasLinkTree(Key key) {
        return this.trees.stream().anyMatch(tree -> tree.contains(key));
    }

    @Override
    public boolean hasLinkTree(World world) {
        return this.hasLinkTree(world.key());
    }

    public Server getServer() {
        return this.plugin.getServer();
    }
}

