package dev.spzla.chatfilters.client;

import dev.spzla.chatfilters.client.config.ChatFiltersConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class ChatFiltersClient implements ClientModInitializer {
    public static Logger LOGGER = LoggerFactory.getLogger("ChatFilters");

    @Override
    public void onInitializeClient() {
        LOGGER.info("ChatFilters Client Initialized");

        getConfig().load();

        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> filterMessage(message));
        ClientReceiveMessageEvents.ALLOW_CHAT.register((text, signedMessage, gameProfile, parameters, instant) -> this.filterMessage(text));
    }

    private boolean filterMessage(class_2561 message) {
        if (!getConfig().enabled) return true;

        if (getConfig().filterMode == FilterMode.BLACKLIST) {
            for (String pattern : getConfig().blacklist) {
                return !message.getString().matches(pattern);
            }
        } else if (getConfig().filterMode == FilterMode.WHITELIST) {
            for (String pattern : getConfig().whitelist) {
                if (!message.getString().matches(pattern)) return false;
            }
        }

        return true;
    }

    public static ChatFiltersConfig getConfig() {
        return ChatFiltersConfig.INSTANCE;
    }
}
