package dev.spzla.chatfilters.client.config;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.CyclingListControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import dev.spzla.chatfilters.client.FilterMode;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.yaml.snakeyaml.Yaml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ChatFiltersConfig {
    public static final ChatFiltersConfig INSTANCE = new ChatFiltersConfig();

    public final Path configFile = FabricLoader.getInstance().getConfigDir().resolve("chatfilters.yml");
    private final Yaml yaml = new Yaml();

    public boolean enabled = true;
    public FilterMode filterMode = FilterMode.BLACKLIST;
    public List<String> blacklist = new ArrayList<>();
    public List<String> whitelist = new ArrayList<>();

    public void save() {
        try {
            Map<String, Object> data = new LinkedHashMap<>();
            data.put("enabled", enabled);
            data.put("filterMode", filterMode.name());
            data.put("blacklist", blacklist);
            data.put("whitelist", whitelist);

            try (Writer writer = Files.newBufferedWriter(configFile)) {
                yaml.dump(data, writer);
            }

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            if (Files.notExists(configFile)) {
                save();
                return;
            }

            try (InputStream inputStream = Files.newInputStream(configFile)) {
                Map<String, Object> data = yaml.load(inputStream);
                if (data != null) {
                    enabled = (Boolean) data.getOrDefault("enabled", true);
                    filterMode = FilterMode.valueOf((String) data.getOrDefault("filterMode", "BLACKLIST"));
                    blacklist = (List<String>) data.getOrDefault("blacklist", new ArrayList<>());
                    whitelist = (List<String>) data.getOrDefault("whitelist", new ArrayList<>());
                }
            }
        } catch (IOException | ClassCastException e) {
            e.printStackTrace();
        }
    }

    public class_437 makeScreen(class_437 parent) {
        return YetAnotherConfigLib.createBuilder()
                .title(class_2561.method_43471("chatfilters.general.title"))
                .category(ConfigCategory.createBuilder()
                        .name(class_2561.method_43471("chatfilters.general.title"))
                        .option(Option.<Boolean>createBuilder()
                                .name(class_2561.method_43471("chatfilters.option.enabled"))
                                .binding(
                                        true,
                                        () -> enabled,
                                        value -> enabled = value
                                )
                                .controller(TickBoxControllerBuilder::create)
                                .build())
                        .option(Option.<FilterMode>createBuilder()
                                .name(class_2561.method_43471("chatfilters.option.filtermode"))
                                .binding(
                                        FilterMode.BLACKLIST,
                                        () -> filterMode,
                                        value -> filterMode = value
                                )
                                .controller(opt -> EnumControllerBuilder.create(opt)
                                        .enumClass(FilterMode.class))
                                .build())
                        .option(ListOption.<String>createBuilder()
                                .name(class_2561.method_43471("chatfilters.option.blacklist"))
                                .binding(
                                        new ArrayList<>(),
                                        () -> blacklist,
                                        value -> blacklist = value
                                )
                                .controller(StringControllerBuilder::create)
                                .initial("")
                                .build())
                        .option(ListOption.<String>createBuilder()
                                .name(class_2561.method_43471("chatfilters.option.whitelist"))
                                .binding(
                                        new ArrayList<>(),
                                        () -> whitelist,
                                        value -> whitelist = value
                                )
                                .controller(StringControllerBuilder::create)
                                .initial("")
                                .build())
                        .build())
                .save(this::save)
                .build()
                .generateScreen(parent);
    }

}
