/*
 * Decompiled with CFR 0.152.
 */
package dev.spzla.chatfilters.client;

import dev.spzla.chatfilters.client.FilterMode;
import dev.spzla.chatfilters.client.config.ChatFiltersConfig;
import java.util.Iterator;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ChatFiltersClient
implements ClientModInitializer {
    public static Logger LOGGER = LoggerFactory.getLogger((String)"ChatFilters");

    public void onInitializeClient() {
        LOGGER.info("ChatFilters Client Initialized");
        ChatFiltersClient.getConfig().load();
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> this.filterMessage(message));
        ClientReceiveMessageEvents.ALLOW_CHAT.register((text, signedMessage, gameProfile, parameters, instant) -> this.filterMessage(text));
    }

    private boolean filterMessage(class_2561 message) {
        if (!ChatFiltersClient.getConfig().enabled) {
            return true;
        }
        if (ChatFiltersClient.getConfig().filterMode == FilterMode.BLACKLIST) {
            Iterator<String> iterator = ChatFiltersClient.getConfig().blacklist.iterator();
            if (iterator.hasNext()) {
                String pattern = iterator.next();
                return !message.getString().matches(pattern);
            }
        } else if (ChatFiltersClient.getConfig().filterMode == FilterMode.WHITELIST) {
            for (String pattern : ChatFiltersClient.getConfig().whitelist) {
                if (message.getString().matches(pattern)) continue;
                return false;
            }
        }
        return true;
    }

    public static ChatFiltersConfig getConfig() {
        return ChatFiltersConfig.INSTANCE;
    }
}

