/*
 * Decompiled with CFR 0.152.
 */
package dev.spzla.chatfilters.client.config;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import dev.spzla.chatfilters.client.FilterMode;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.yaml.snakeyaml.Yaml;

@Environment(value=EnvType.CLIENT)
public class ChatFiltersConfig {
    public static final ChatFiltersConfig INSTANCE = new ChatFiltersConfig();
    public final Path configFile = FabricLoader.getInstance().getConfigDir().resolve("chatfilters.yml");
    private final Yaml yaml = new Yaml();
    public boolean enabled = true;
    public FilterMode filterMode = FilterMode.BLACKLIST;
    public List<String> blacklist = new ArrayList<String>();
    public List<String> whitelist = new ArrayList<String>();

    public void save() {
        try {
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            data.put("enabled", this.enabled);
            data.put("filterMode", this.filterMode.name());
            data.put("blacklist", this.blacklist);
            data.put("whitelist", this.whitelist);
            try (BufferedWriter writer = Files.newBufferedWriter(this.configFile, new OpenOption[0]);){
                this.yaml.dump(data, (Writer)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            if (Files.notExists(this.configFile, new LinkOption[0])) {
                this.save();
                return;
            }
            try (InputStream inputStream = Files.newInputStream(this.configFile, new OpenOption[0]);){
                Map data = (Map)this.yaml.load(inputStream);
                if (data != null) {
                    this.enabled = data.getOrDefault("enabled", true);
                    this.filterMode = FilterMode.valueOf(data.getOrDefault("filterMode", "BLACKLIST"));
                    this.blacklist = data.getOrDefault("blacklist", new ArrayList());
                    this.whitelist = data.getOrDefault("whitelist", new ArrayList());
                }
            }
        }
        catch (IOException | ClassCastException e) {
            e.printStackTrace();
        }
    }

    public class_437 makeScreen(class_437 parent) {
        return YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"chatfilters.general.title")).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"chatfilters.general.title")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"chatfilters.option.enabled")).binding((Object)true, () -> this.enabled, value -> {
            this.enabled = value;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"chatfilters.option.filtermode")).binding((Object)FilterMode.BLACKLIST, () -> this.filterMode, value -> {
            this.filterMode = value;
        }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(FilterMode.class)).build()).option((Option)ListOption.createBuilder().name((class_2561)class_2561.method_43471((String)"chatfilters.option.blacklist")).binding(new ArrayList(), () -> this.blacklist, value -> {
            this.blacklist = value;
        }).controller(StringControllerBuilder::create).initial((Object)"").build()).option((Option)ListOption.createBuilder().name((class_2561)class_2561.method_43471((String)"chatfilters.option.whitelist")).binding(new ArrayList(), () -> this.whitelist, value -> {
            this.whitelist = value;
        }).controller(StringControllerBuilder::create).initial((Object)"").build()).build()).save(this::save).build().generateScreen(parent);
    }
}

