/*
 * Decompiled with CFR 0.152.
 */
package mc.obliviate.inventory.advancedslot;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import mc.obliviate.inventory.Icon;
import mc.obliviate.inventory.advancedslot.AdvancedSlotManager;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class AdvancedSlot {
    private boolean refundOnClose = true;
    private final int slot;
    private final Icon displayIcon;
    private final AdvancedSlotManager advancedSlotManager;
    private BiPredicate<InventoryClickEvent, ItemStack> prePutClickAction = (e, item) -> false;
    private BiPredicate<InventoryClickEvent, ItemStack> prePickupClickAction = (e, item) -> false;
    private BiConsumer<InventoryClickEvent, ItemStack> pickupAction = (e, item) -> {};
    private BiConsumer<InventoryClickEvent, ItemStack> putAction = (e, item) -> {};

    public AdvancedSlot(int slot, Icon displayIcon, AdvancedSlotManager advancedSlotManager) {
        this.slot = slot;
        this.advancedSlotManager = advancedSlotManager;
        this.displayIcon = displayIcon.onClick(e -> {
            if (!AdvancedSlotManager.isNullOrAir(e.getCursor())) {
                if (this.prePutClickAction.test((InventoryClickEvent)e, e.getCursor())) {
                    return;
                }
                ItemStack cursor = e.getCursor();
                ItemStack newCursor = null;
                if (e.isRightClick()) {
                    if (cursor.getAmount() > 1) {
                        newCursor = cursor.clone();
                        newCursor.setAmount(newCursor.getAmount() - 1);
                    }
                    cursor.setAmount(1);
                }
                e.setCursor(newCursor);
                this.advancedSlotManager.putIconToAdvancedSlot(this, cursor, (InventoryClickEvent)e);
            } else if (e.getAction().equals((Object)InventoryAction.HOTBAR_MOVE_AND_READD)) {
                ItemStack hotbarItem = Objects.requireNonNull(AdvancedSlotManager.getItemStackFromHotkeyClick(e));
                if (this.prePutClickAction.test((InventoryClickEvent)e, hotbarItem)) {
                    return;
                }
                this.advancedSlotManager.putIconToAdvancedSlot(this, hotbarItem, (InventoryClickEvent)e);
                e.getWhoClicked().getInventory().setItem(e.getHotbarButton(), null);
            }
        });
    }

    @Nonnull
    public BiPredicate<InventoryClickEvent, ItemStack> getPrePutClickAction() {
        return this.prePutClickAction;
    }

    @Nonnull
    public BiConsumer<InventoryClickEvent, ItemStack> getPickupAction() {
        return this.pickupAction;
    }

    @Nonnull
    public BiConsumer<InventoryClickEvent, ItemStack> getPutAction() {
        return this.putAction;
    }

    @Nonnull
    public BiPredicate<InventoryClickEvent, ItemStack> getPrePickupClickAction() {
        return this.prePickupClickAction;
    }

    public AdvancedSlot onPickup(BiConsumer<InventoryClickEvent, ItemStack> pickupAction) {
        this.pickupAction = Objects.requireNonNull(pickupAction, "pickup action cannot be null");
        return this;
    }

    public AdvancedSlot onPut(BiConsumer<InventoryClickEvent, ItemStack> putAction) {
        this.putAction = Objects.requireNonNull(putAction, "put action cannot be null");
        return this;
    }

    public AdvancedSlot onPrePutClick(BiPredicate<InventoryClickEvent, ItemStack> prePutClickAction) {
        this.prePutClickAction = Objects.requireNonNull(prePutClickAction, "prePut action cannot be null");
        return this;
    }

    public AdvancedSlot onPrePickupClick(BiPredicate<InventoryClickEvent, ItemStack> prePickupClick) {
        this.prePickupClickAction = Objects.requireNonNull(prePickupClick, "prePickup action cannot be null");
        return this;
    }

    public Icon getDisplayIcon() {
        return this.displayIcon;
    }

    public void reset() {
        this.advancedSlotManager.getGui().addItem(this.slot, this.getDisplayIcon());
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemStack getItemStack() {
        ItemStack itemOnSlot = this.advancedSlotManager.getGui().getInventory().getItem(this.getSlot());
        if (Objects.equals(this.getDisplayIcon().getItem(), itemOnSlot)) {
            return null;
        }
        return itemOnSlot;
    }

    public boolean isRefundOnClose() {
        return this.refundOnClose;
    }

    public void setRefundOnClose(boolean refundOnClose) {
        this.refundOnClose = refundOnClose;
    }
}

