/*
 * Decompiled with CFR 0.152.
 */
package mc.obliviate.inventory.advancedslot;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mc.obliviate.inventory.Gui;
import mc.obliviate.inventory.Icon;
import mc.obliviate.inventory.InventoryAPI;
import mc.obliviate.inventory.advancedslot.AdvancedSlot;
import mc.obliviate.inventory.advancedslot.AdvancedSlotListener;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class AdvancedSlotManager {
    protected static final Map<Gui, AdvancedSlotManager> ADVANCED_SLOT_MANAGERS = new HashMap<Gui, AdvancedSlotManager>();
    private final Map<Integer, AdvancedSlot> slots = new HashMap<Integer, AdvancedSlot>();
    private final Gui gui;

    public AdvancedSlotManager(Gui gui) {
        this.gui = gui;
        AdvancedSlotListener.poke();
        ADVANCED_SLOT_MANAGERS.put(gui, this);
    }

    public Gui getGui() {
        return this.gui;
    }

    public Collection<AdvancedSlot> getSlots() {
        return this.slots.values();
    }

    @Nonnull
    public AdvancedSlot addAdvancedIcon(int slot, Icon icon) {
        AdvancedSlot aSlot = new AdvancedSlot(slot, icon, this);
        this.registerSlot(aSlot);
        aSlot.reset();
        return aSlot;
    }

    public void putIconToAdvancedSlot(@Nonnull AdvancedSlot aSlot, @Nonnull ItemStack item) {
        this.putIconToAdvancedSlot(aSlot, item, null);
    }

    public void putIconToAdvancedSlot(@Nonnull AdvancedSlot aSlot, @Nonnull ItemStack item, @Nullable InventoryClickEvent event) {
        this.gui.addItem(aSlot.getSlot(), new Icon(item).onClick((InventoryClickEvent e) -> {
            switch (e.getAction()) {
                case PLACE_ALL: 
                case PLACE_SOME: 
                case PLACE_ONE: {
                    break;
                }
                default: {
                    if (!aSlot.getPrePickupClickAction().test((InventoryClickEvent)e, e.getCurrentItem())) break;
                    return;
                }
            }
            switch (e.getAction()) {
                case HOTBAR_MOVE_AND_READD: 
                case HOTBAR_SWAP: {
                    ItemStack hotbarItem = AdvancedSlotManager.getItemStackFromHotkeyClick(e);
                    if (AdvancedSlotManager.isNullOrAir(hotbarItem) || !aSlot.getPrePutClickAction().test((InventoryClickEvent)e, hotbarItem)) break;
                    return;
                }
                case SWAP_WITH_CURSOR: {
                    if (AdvancedSlotManager.isNullOrAir(e.getCursor()) || !aSlot.getPrePutClickAction().test((InventoryClickEvent)e, e.getCursor())) break;
                    return;
                }
                case PLACE_ALL: 
                case PLACE_SOME: 
                case PLACE_ONE: {
                    if (!aSlot.getPrePutClickAction().test((InventoryClickEvent)e, e.getCursor())) break;
                    return;
                }
            }
            e.setCancelled(false);
            switch (e.getAction()) {
                case PICKUP_ONE: 
                case DROP_ONE_SLOT: {
                    aSlot.getPickupAction().accept((InventoryClickEvent)e, AdvancedSlotManager.getCopyOfItemWithAmount(e.getCurrentItem(), 1));
                    break;
                }
                case PICKUP_HALF: {
                    int amount = e.getCurrentItem().getAmount() / 2 + (e.getCurrentItem().getAmount() % 2 == 0 ? 0 : 1);
                    aSlot.getPickupAction().accept((InventoryClickEvent)e, AdvancedSlotManager.getCopyOfItemWithAmount(e.getCurrentItem(), amount));
                    break;
                }
                case MOVE_TO_OTHER_INVENTORY: 
                case PICKUP_ALL: 
                case DROP_ALL_SLOT: {
                    aSlot.getPickupAction().accept((InventoryClickEvent)e, e.getCurrentItem());
                    break;
                }
                case SWAP_WITH_CURSOR: {
                    aSlot.getPickupAction().accept((InventoryClickEvent)e, e.getCurrentItem());
                    aSlot.getPutAction().accept((InventoryClickEvent)e, e.getCursor());
                    break;
                }
                case HOTBAR_MOVE_AND_READD: 
                case HOTBAR_SWAP: {
                    aSlot.getPickupAction().accept((InventoryClickEvent)e, e.getCurrentItem());
                    ItemStack hotbarItem = AdvancedSlotManager.getItemStackFromHotkeyClick(e);
                    if (hotbarItem == null) break;
                    aSlot.getPutAction().accept((InventoryClickEvent)e, hotbarItem);
                    break;
                }
                case PLACE_ONE: {
                    aSlot.getPutAction().accept((InventoryClickEvent)e, AdvancedSlotManager.getCopyOfItemWithAmount(e.getCursor(), 1));
                    break;
                }
                case PLACE_SOME: {
                    aSlot.getPutAction().accept((InventoryClickEvent)e, AdvancedSlotManager.getCopyOfItemWithAmount(e.getCursor(), e.getCursor().getMaxStackSize()));
                    break;
                }
                case PLACE_ALL: {
                    aSlot.getPutAction().accept((InventoryClickEvent)e, e.getCursor());
                    break;
                }
                default: {
                    return;
                }
            }
            InventoryAPI.getScheduler().runTaskLater(() -> {
                if (this.gui.getInventory().getItem(aSlot.getSlot()) == null) {
                    aSlot.reset();
                }
            }, 1L);
        }));
        if (event != null) {
            aSlot.getPutAction().accept(event, event.getCurrentItem());
        }
    }

    public void onClick(InventoryClickEvent e) {
        if (e.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
            if (e.getRawSlot() == e.getSlot()) {
                return;
            }
            for (AdvancedSlot aSlot : this.getSlots()) {
                ItemStack itemOnSlot = this.gui.getInventory().getItem(aSlot.getSlot());
                ItemStack clickedItem = e.getCurrentItem();
                if (AdvancedSlotManager.isNullOrAir(itemOnSlot) && AdvancedSlotManager.isNullOrAir(aSlot.getDisplayIcon().getItem()) || aSlot.getDisplayIcon().getItem().equals((Object)itemOnSlot)) {
                    if (aSlot.getPrePutClickAction().test(e, clickedItem)) continue;
                    this.putIconToAdvancedSlot(aSlot, clickedItem, e);
                    e.setCurrentItem(new ItemStack(Material.AIR));
                    return;
                }
                if (clickedItem == null || itemOnSlot == null || !AdvancedSlotManager.compareSimilar(clickedItem, itemOnSlot) || itemOnSlot.getAmount() >= itemOnSlot.getType().getMaxStackSize() || aSlot.getPrePutClickAction().test(e, clickedItem)) continue;
                int maxSize = itemOnSlot.getType().getMaxStackSize();
                int transferSize = maxSize <= itemOnSlot.getAmount() + clickedItem.getAmount() ? maxSize - itemOnSlot.getAmount() : clickedItem.getAmount();
                itemOnSlot.setAmount(itemOnSlot.getAmount() + transferSize);
                clickedItem.setAmount(clickedItem.getAmount() - transferSize);
                if (clickedItem.getAmount() == 0) {
                    clickedItem = new ItemStack(Material.AIR);
                }
                e.setCurrentItem(clickedItem);
                this.putIconToAdvancedSlot(aSlot, itemOnSlot, e);
                return;
            }
        }
    }

    public void onClose(InventoryCloseEvent e) {
        for (int slot : this.slots.keySet()) {
            AdvancedSlot advancedSlot;
            ItemStack itemOnSlot = e.getInventory().getItem(slot);
            if (itemOnSlot == null || !(advancedSlot = this.slots.get(slot)).isRefundOnClose() || AdvancedSlotManager.compareSimilar(itemOnSlot, advancedSlot.getDisplayIcon().getItem())) continue;
            InventoryView openInventory = e.getPlayer().getOpenInventory();
            Inventory bottomInventory = openInventory.getBottomInventory();
            if (this.hasSpace(bottomInventory)) {
                bottomInventory.addItem(new ItemStack[]{itemOnSlot});
                continue;
            }
            e.getPlayer().getWorld().dropItemNaturally(e.getPlayer().getLocation(), itemOnSlot);
        }
    }

    public void registerSlot(AdvancedSlot slot) {
        this.slots.put(slot.getSlot(), slot);
    }

    private boolean hasSpace(Inventory inventory) {
        return Arrays.stream(inventory.getContents()).anyMatch(Objects::isNull);
    }

    public static Map<Gui, AdvancedSlotManager> getAdvancedSlotManagers() {
        return Collections.unmodifiableMap(ADVANCED_SLOT_MANAGERS);
    }

    static ItemStack getCopyOfItemWithAmount(ItemStack item, int amount) {
        ItemStack result = item.clone();
        result.setAmount(amount);
        return result;
    }

    static ItemStack getItemStackFromHotkeyClick(InventoryClickEvent event) {
        if (event.getHotbarButton() == -1) {
            return null;
        }
        return event.getWhoClicked().getInventory().getItem(event.getHotbarButton());
    }

    static boolean isNullOrAir(ItemStack item) {
        return item == null || item.getType().equals((Object)Material.AIR);
    }

    private static boolean compareSimilar(ItemStack item1, ItemStack item2) {
        boolean inoa2;
        boolean inoa1 = AdvancedSlotManager.isNullOrAir(item1);
        if (inoa1 ^ (inoa2 = AdvancedSlotManager.isNullOrAir(item2))) {
            return false;
        }
        return item1.isSimilar(item2);
    }
}

