/*
 * Decompiled with CFR 0.152.
 */
package mc.obliviate.inventory.pagination;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import mc.obliviate.inventory.Gui;
import mc.obliviate.inventory.Icon;

public class PaginationManager {
    private final Gui gui;
    private final LinkedList<Integer> slots = new LinkedList();
    private final LinkedList<Icon> items = new LinkedList();
    private int page;

    public PaginationManager(Gui gui) {
        this.gui = gui;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public void registerPageSlots(Integer ... slots) {
        this.registerPageSlots(Arrays.asList(slots));
    }

    public void registerPageSlots(List<Integer> slots) {
        this.slots.addAll(slots);
    }

    public void registerPageSlotsBetween(int from, int to) {
        if (from > to) {
            this.registerPageSlotsBetween(to, from);
            return;
        }
        while (from <= to) {
            this.slots.add(from);
            ++from;
        }
    }

    public void unregisterAllPageSlots() {
        this.slots.clear();
    }

    public Gui getGui() {
        return this.gui;
    }

    public int getCurrentPage() {
        return this.page;
    }

    public PaginationManager setPage(int page) {
        this.page = page;
        return this;
    }

    public PaginationManager goNextPage() {
        if (this.page >= this.getLastPage()) {
            return this;
        }
        ++this.page;
        return this;
    }

    public PaginationManager goPreviousPage() {
        if (this.page <= 0) {
            return this;
        }
        --this.page;
        return this;
    }

    public PaginationManager goFirstPage() {
        this.page = 0;
        return this;
    }

    public PaginationManager goLastPage() {
        this.page = this.getLastPage();
        return this;
    }

    public boolean isLastPage() {
        return this.page == this.getLastPage();
    }

    public boolean isFirstPage() {
        return this.page == 0;
    }

    public int getLastPage() {
        if (this.slots.isEmpty() || this.items.isEmpty()) {
            return 0;
        }
        int division = (int)Math.floor(this.items.size() / this.slots.size());
        if (this.items.size() % this.slots.size() == 0) {
            return division - 1;
        }
        return division;
    }

    public void addItem(Icon ... icons) {
        this.items.addAll(Arrays.asList(icons));
    }

    public List<Icon> getItems() {
        return this.items;
    }

    public void update() {
        if (this.page < 0) {
            return;
        }
        for (int slotNo = 0; slotNo < this.slots.size(); ++slotNo) {
            int itemNo = slotNo + this.page * this.slots.size();
            if (this.items.size() > itemNo) {
                this.gui.addItem((int)this.slots.get(slotNo), this.items.get(itemNo));
                continue;
            }
            this.gui.addItem(null, this.slots.get(slotNo));
        }
    }
}

