/*
 * Decompiled with CFR 0.152.
 */
package mc.obliviate.util.database;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ListSerializer<T> {
    private static final String DEFAULT_DELIMITER = ",";

    public String serializeList(List<T> list) {
        return this.serializeList(list, String::valueOf);
    }

    public String serializeList(List<T> list, Function<T, String> serializer) {
        return this.serializeList(list, serializer, DEFAULT_DELIMITER);
    }

    public String serializeList(List<T> list, Function<T, String> serializer, String delimiter) {
        ArrayList result = new ArrayList();
        list.forEach(obj -> result.add(serializer.apply(obj)));
        return String.join((CharSequence)delimiter, result);
    }

    public List<T> deserializeList(String serializedString, Function<String, T> deserializer) {
        if (serializedString.isEmpty()) {
            return new ArrayList();
        }
        return this.deserializeList(serializedString, deserializer, DEFAULT_DELIMITER);
    }

    public List<T> deserializeList(String serializedString, Function<String, T> deserializer, String delimiter) {
        String[] values;
        ArrayList<T> result = new ArrayList<T>();
        for (String value : values = serializedString.split(delimiter)) {
            result.add(deserializer.apply(value));
        }
        return result;
    }
}

