/*
 * Decompiled with CFR 0.152.
 */
package mc.obliviate.util.database.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mc.obliviate.util.database.Database;
import mc.obliviate.util.database.sql.ColumnValues;
import mc.obliviate.util.database.sql.SQLDriverProvider;

public abstract class SQLDatabase<T>
implements Database<T> {
    private final SQLDriverProvider provider;

    protected SQLDatabase(SQLDriverProvider provider) {
        this.provider = provider;
    }

    public abstract List<ColumnValues> serialize(T var1);

    public abstract T deserialize(ResultSet var1) throws SQLException;

    @Override
    public void save(T object) {
        if (object == null) {
            throw new NullPointerException("object could not save because it was null!");
        }
        String id = this.getId(object);
        List<ColumnValues> columns = this.serialize(object);
        boolean exist = this.exist(this.queryString(id));
        if (exist) {
            this.update(SQLDatabase.getUpdateCommand(this.getTable(), this.getIdColumn(), (Object)id, columns));
        } else {
            this.update(SQLDatabase.getInsertCommand(this.getTable(), columns));
        }
    }

    @Override
    public T load(Object id) {
        if (id == null) {
            throw new NullPointerException("id cannot be null");
        }
        ResultSet rs = this.query(this.queryString(id));
        try {
            return this.deserialize(rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<T> loadAll() {
        ResultSet rs = this.query("SELECT * FROM " + this.getTable());
        ArrayList<T> result = new ArrayList<T>();
        try {
            while (true) {
                T obj;
                if ((obj = this.deserialize(rs)) == null) {
                    return result;
                }
                result.add(obj);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void update(List<String> sqls) {
        sqls.forEach(this::update);
    }

    public void update(String sql) {
        try {
            System.out.println(sql);
            Statement statement = this.provider.getConnection().createStatement();
            statement.executeUpdate(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void query(List<String> sqls) {
        sqls.forEach(this::query);
    }

    public ResultSet query(String sql) {
        try {
            System.out.println(sql);
            Statement statement = this.provider.getConnection().createStatement();
            return statement.executeQuery(sql);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean exist(String sql) {
        ResultSet rs = this.query(sql);
        try {
            return rs.next();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String queryString(Object id) {
        if (id == null) {
            throw new NullPointerException("id cannot be null");
        }
        return "SELECT * FROM " + this.getTable() + " WHERE " + this.getIdColumn() + "='" + id + "'";
    }

    public abstract String getId(T var1);

    public abstract String getIdColumn();

    public abstract String getTable();

    public static List<String> getUpdateCommand(String table, String where, Object whereValue, List<ColumnValues> columns) {
        return columns.stream().map(col -> SQLDatabase.getUpdateCommand(table, where, whereValue, col)).collect(Collectors.toList());
    }

    public static String getUpdateCommand(String table, String where, Object whereValue, ColumnValues columns) {
        StringBuilder stringBuilder = new StringBuilder("UPDATE ").append(table).append(" SET ");
        int i = 0;
        for (String str : columns.getColumnValues().keySet()) {
            stringBuilder.append(str).append(" = ").append("'").append(columns.getColumnValues().get(str)).append("'");
            if (++i == columns.getColumnValues().size()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" WHERE ").append(where).append(" = '").append(whereValue.toString()).append("'");
        return stringBuilder.toString();
    }

    public static List<String> getInsertCommand(String table, List<ColumnValues> columns) {
        return columns.stream().map(col -> SQLDatabase.getInsertCommand(table, col)).collect(Collectors.toList());
    }

    public static String getInsertCommand(String table, ColumnValues columns) {
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO ").append(table).append(" VALUES(");
        int i = 0;
        for (Object obj : columns.getColumnValues().values()) {
            ++i;
            if (obj instanceof Number) {
                stringBuilder.append(obj);
            } else {
                stringBuilder.append("'").append(obj).append("'");
            }
            if (i == columns.getColumnValues().size()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public SQLDriverProvider getProvider() {
        return this.provider;
    }
}

