/*
 * Decompiled with CFR 0.152.
 */
package mc.obliviate.util.string;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mc.obliviate.util.versiondetection.ServerVersionController;
import net.md_5.bungee.api.ChatColor;

public class StringUtil {
    private static final Pattern HEX_PATTERN = Pattern.compile("<#[a-fA-F\\d]{6}>");

    public static List<String> listReplace(List<String> stringList, String search, String replace) {
        if (stringList == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String str : stringList) {
            result.add(str.replace(search, replace));
        }
        return result;
    }

    public static String parseColor(String string) {
        if (string == null) {
            return null;
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        if (ServerVersionController.isServerVersionAtLeast(ServerVersionController.V1_16)) {
            Matcher matcher = HEX_PATTERN.matcher(string);
            while (matcher.find()) {
                ChatColor hexColor = ChatColor.of((String)matcher.group().substring(1, matcher.group().length() - 1));
                String before = string.substring(0, matcher.start());
                String after = string.substring(matcher.end());
                string = before + hexColor + after;
                matcher = HEX_PATTERN.matcher(string);
            }
        }
        return string;
    }

    public static List<String> parseColor(List<String> stringList) {
        if (stringList == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String str : stringList) {
            result.add(StringUtil.parseColor(str));
        }
        return result;
    }

    public static int getPercentage(double total, double progress) {
        try {
            return (int)(progress / (total / 100.0));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String getProgressBar(int completed, int total, String got, String missing) {
        StringBuilder points = new StringBuilder();
        int i = 0;
        while (i + 1 <= total) {
            if (i >= completed) {
                points.append(missing);
            } else {
                points.append(got);
            }
            ++i;
        }
        return points.toString();
    }

    public static double getFirstDigits(double number, int digitAmount) {
        double multiple = Math.pow(10.0, digitAmount);
        return (double)((int)(number * multiple)) / multiple;
    }
}

