/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems;

import java.util.logging.Logger;
import mc.obliviate.inventory.InventoryAPI;
import net.pullolo.aetheriumItems.ModifiableItems;
import net.pullolo.aetheriumItems.commands.Command;
import net.pullolo.aetheriumItems.commands.Items;
import net.pullolo.aetheriumItems.events.ItemsEventsHandler;
import net.pullolo.aetheriumItems.scrolls.Recipes;
import net.pullolo.aetheriumItems.scrolls.custom.BleedingScroll;
import net.pullolo.aetheriumItems.scrolls.custom.DayScroll;
import net.pullolo.aetheriumItems.scrolls.custom.DragonSkinScroll;
import net.pullolo.aetheriumItems.scrolls.custom.EndermanScroll;
import net.pullolo.aetheriumItems.scrolls.custom.FrostNovaScroll;
import net.pullolo.aetheriumItems.scrolls.custom.HasteScroll;
import net.pullolo.aetheriumItems.scrolls.custom.LaserScroll;
import net.pullolo.aetheriumItems.scrolls.custom.ShadowstepScroll;
import net.pullolo.aetheriumItems.scrolls.custom.ShriekScroll;
import net.pullolo.aetheriumItems.scrolls.custom.TreecapitatorScroll;
import net.pullolo.aetheriumItems.scrolls.custom.WeatherScroll;
import net.pullolo.aetheriumItems.scrolls.custom.WindScroll;
import net.pullolo.aetheriumItems.utils.CooldownApi;
import net.pullolo.aetheriumItems.utils.ParticleApi;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class AetheriumItems
extends JavaPlugin {
    public static JavaPlugin aetheriumItemsPlugin;
    private static final Logger logger;
    private static final String prefix = "[AetheriumItems] ";
    private FileConfiguration config;
    private InventoryAPI inventoryAPI;
    public static ParticleApi particleApi;

    public void onEnable() {
        aetheriumItemsPlugin = this;
        this.saveDefaultConfig();
        try {
            this.inventoryAPI = new InventoryAPI(this);
            this.inventoryAPI.init();
            AetheriumItems.logInfo("GUI library initialized!");
        }
        catch (Exception e) {
            AetheriumItems.logWarning("GUI library failed to initialize!");
        }
        this.config = this.getConfig();
        particleApi = new ParticleApi(this);
        this.init();
        Recipes.init();
        this.createCooldowns();
        this.getServer().getPluginManager().registerEvents((Listener)new ItemsEventsHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EndermanScroll(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TreecapitatorScroll(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BleedingScroll(), (Plugin)this);
        this.registerCommand(new Items(), "items");
    }

    private void createCooldowns() {
        CooldownApi.createCooldown("wind-scroll", new WindScroll().getCooldown());
        CooldownApi.createCooldown("shriek-scroll", new ShriekScroll().getCooldown());
        CooldownApi.createCooldown("weather-scroll", new WeatherScroll().getCooldown());
        CooldownApi.createCooldown("day-scroll", new DayScroll().getCooldown());
        CooldownApi.createCooldown("dragon-skin-scroll", new DragonSkinScroll().getCooldown());
        CooldownApi.createCooldown("haste-scroll", new HasteScroll().getCooldown());
        CooldownApi.createCooldown("treecapitator-scroll", new TreecapitatorScroll().getCooldown());
        CooldownApi.createCooldown("laser-scroll", new LaserScroll().getCooldown());
        CooldownApi.createCooldown("frost-nova-scroll", new FrostNovaScroll().getCooldown());
        CooldownApi.createCooldown("shadowstep-scroll", new ShadowstepScroll().getCooldown());
    }

    public void onDisable() {
        this.disableGuis();
    }

    private void disableGuis() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            try {
                this.inventoryAPI.getPlayersCurrentGui(p).getInventory().close();
            }
            catch (Exception e) {}
        }
        if (this.inventoryAPI != null) {
            this.inventoryAPI.unload();
        }
    }

    private void init() {
        try {
            new ModifiableItems(this.config.getStringList("convertable"));
        }
        catch (Exception e) {
            AetheriumItems.logWarning(e.getMessage());
        }
    }

    private void registerCommand(Command cmd, String cmdName) {
        this.getCommand(cmdName).setExecutor((CommandExecutor)cmd);
        this.getCommand(cmdName).setTabCompleter((TabCompleter)cmd);
    }

    public static void logInfo(String s) {
        logger.info(prefix + s);
    }

    public static void logWarning(String s) {
        logger.warning(prefix + s);
    }

    static {
        logger = Logger.getLogger("Minecraft");
    }
}

