/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems;

import java.util.ArrayList;
import java.util.List;
import net.pullolo.aetheriumItems.AetheriumItems;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ModifiableItems {
    private static final ArrayList<Material> materials = new ArrayList();

    public ModifiableItems(List<String> items) {
        if (!materials.isEmpty()) {
            return;
        }
        for (String s : items) {
            try {
                materials.add(Material.valueOf((String)s));
            }
            catch (Exception e) {
                AetheriumItems.logWarning("Cannot convert " + s + " to Material!");
            }
        }
    }

    public static boolean canBeConverted(ItemStack item) {
        return materials.contains(item.getType());
    }

    public static boolean isArmor(ItemStack item) {
        String i = item.getType().toString().toLowerCase();
        return i.contains("helmet") || i.contains("chestplate") || i.contains("leggings") || i.contains("boots");
    }

    public static boolean isRange(ItemStack item) {
        return item.getType().toString().toLowerCase().contains("bow");
    }
}

