/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.events;

import java.util.Objects;
import net.pullolo.aetheriumItems.AetheriumItems;
import net.pullolo.aetheriumItems.ModifiableItems;
import net.pullolo.aetheriumItems.items.Item;
import net.pullolo.aetheriumItems.scrolls.PassiveAbility;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemsEventsHandler
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player p = event.getPlayer();
        ItemStack heldItem = p.getInventory().getItemInMainHand();
        if (!heldItem.hasItemMeta()) {
            return;
        }
        Item i = new Item(heldItem);
        if (i.isCustomItem() && i.hasScroll() && i.getScroll() instanceof PassiveAbility) {
            ((PassiveAbility)((Object)i.getScroll())).onApply(p);
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        Player p = event.getPlayer();
        ItemStack heldItem = p.getInventory().getItemInMainHand();
        if (!heldItem.hasItemMeta()) {
            return;
        }
        Item i = new Item(heldItem);
        if (i.isCustomItem() && i.hasScroll() && i.getScroll() instanceof PassiveAbility) {
            ((PassiveAbility)((Object)i.getScroll())).onRemove(p);
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        Player p = event.getPlayer();
        ItemStack dropped = event.getItemDrop().getItemStack();
        if (!dropped.hasItemMeta()) {
            return;
        }
        Item i = new Item(dropped);
        if (i.isCustomItem() && i.hasScroll() && i.getScroll() instanceof PassiveAbility) {
            ((PassiveAbility)((Object)i.getScroll())).onRemove(p);
        }
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack pickedUpItem = event.getItem().getItemStack();
        if (!pickedUpItem.hasItemMeta()) {
            return;
        }
        Item i = new Item(pickedUpItem);
        if (i.isCustomItem() && i.hasScroll() && i.getScroll() instanceof PassiveAbility) {
            ((PassiveAbility)((Object)i.getScroll())).onApply(player);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack oldItem = player.getInventory().getItemInMainHand();
        Item old = oldItem.hasItemMeta() ? new Item(oldItem) : null;
        Bukkit.getScheduler().runTask((Plugin)AetheriumItems.aetheriumItemsPlugin, () -> {
            Item now;
            ItemStack newItem = player.getInventory().getItemInMainHand();
            Item item = now = newItem.hasItemMeta() ? new Item(newItem) : null;
            if (old != null && old.isCustomItem() && old.hasScroll() && old.getScroll() instanceof PassiveAbility) {
                ((PassiveAbility)((Object)old.getScroll())).onRemove(player);
            }
            if (now != null && now.isCustomItem() && now.hasScroll() && now.getScroll() instanceof PassiveAbility) {
                ((PassiveAbility)((Object)now.getScroll())).onApply(player);
            }
        });
    }

    @EventHandler
    public void onItemHeld(PlayerItemHeldEvent event) {
        Item customNewItem;
        Item customPrevItem;
        Player p = event.getPlayer();
        ItemStack prevItem = p.getInventory().getItem(event.getPreviousSlot());
        ItemStack newItem = p.getInventory().getItem(event.getNewSlot());
        if (prevItem != null && (customPrevItem = new Item(prevItem)).isCustomItem() && customPrevItem.hasScroll() && customPrevItem.getScroll() instanceof PassiveAbility) {
            ((PassiveAbility)((Object)customPrevItem.getScroll())).onRemove(p);
        }
        if (newItem != null && (customNewItem = new Item(newItem)).isCustomItem() && customNewItem.hasScroll() && customNewItem.getScroll() instanceof PassiveAbility) {
            ((PassiveAbility)((Object)customNewItem.getScroll())).onApply(p);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getItem() == null || event.getItem().getItemMeta() == null) {
            return;
        }
        if (!Objects.equals(event.getHand(), EquipmentSlot.HAND)) {
            return;
        }
        Item item = new Item(event.getItem());
        if (!item.isCustomItem()) {
            return;
        }
        if (item.getItemStack().getType().toString().toLowerCase().contains("_banner_pattern")) {
            event.setCancelled(true);
            return;
        }
        if (!item.hasScroll()) {
            return;
        }
        if (ModifiableItems.isRange(item.getItemStack()) ? !event.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK) : !event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && !event.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) {
            return;
        }
        Player p = event.getPlayer();
        Scroll.getScroll(item.getScroll().getType()).executeAbility(p);
    }
}

