/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.gui;

import java.util.ArrayList;
import mc.obliviate.inventory.Gui;
import mc.obliviate.inventory.Icon;
import net.pullolo.aetheriumItems.AetheriumItems;
import net.pullolo.aetheriumItems.gui.RecipesGui;
import net.pullolo.aetheriumItems.gui.base.BaseBackGui;
import net.pullolo.aetheriumItems.scrolls.Recipes;
import net.pullolo.aetheriumItems.utils.Utils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class Guide
extends BaseBackGui {
    private BukkitRunnable updater;

    public Guide(@NotNull Player player, Gui prevGui) {
        super(player, "aei-guide", "Guide", 3, prevGui);
    }

    private ArrayList<Material> getRecipe(int i) {
        ArrayList<ArrayList<Material>> allRecipes = new ArrayList<ArrayList<Material>>(Recipes.scrollRecipes.keySet());
        return allRecipes.get(i % allRecipes.size());
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        super.onClose(event);
        this.updater.cancel();
        this.updater = null;
    }

    @Override
    public void onOpen(InventoryOpenEvent event) {
        this.fillGui(this.createFiller());
        this.addItem(18, this.createBackItem());
        this.addItem(10, this.createGuideIcon(Material.PURPLE_STAINED_GLASS_PANE, "&dScroll Item Slot", " &8\u2022 The item slot above requires magic scroll."));
        this.addItem(11, this.createGuideIcon(Material.RED_STAINED_GLASS_PANE, "&cItem Slot", " &8\u2022 The item slot above requires an ordinary item."));
        this.addItem(12, this.createGuideIcon(Material.CRAFTING_TABLE, "&aAction Button", " &8\u2022 Press it to \"craft\" given items."));
        this.addItem(13, this.createGuideIcon(Material.BOOK, "&aScroll Refining", " &8\u2022 You need to first refine a book to an empty scroll.\n &8\u2022 With an empty scroll u can perform scroll crafting.\n &8\u2022 The odds of a successful refine are &720%&8."));
        this.addItem(14, this.createGuideIcon(Material.WRITABLE_BOOK, "&dScroll Crafting", " &8\u2022 Using an empty scroll and other ingredients,\n   &8you can now craft a magical scroll."));
        this.addItem(15, this.createRecipeGuideIcon(Material.NETHERITE_SWORD, "&cRecipes", " &8\u2022 I would suggest trying different materials."));
        this.addItem(16, this.createGuideIcon(Material.ANVIL, "&bMagic Anvil", " &8\u2022 Use it to combine the scroll with your item."));
        this.updater = this.getUpdater();
        this.updater.runTaskTimer((Plugin)AetheriumItems.aetheriumItemsPlugin, 0L, 30L);
    }

    private Icon createGuideIcon(Material m, String name, String lore) {
        Icon i = new Icon(m);
        i.setName(Utils.translate(name));
        i.setLore(Utils.translate(lore).split("\n"));
        return i;
    }

    private Icon createRecipeGuideIcon(Material m, String name, String lore) {
        Icon i = new Icon(m);
        i.setName(Utils.translate(name));
        i.setLore(Utils.translate(lore).split("\n"));
        i.onClick((InventoryClickEvent click) -> {
            this.getInventory().close();
            new RecipesGui(this.owner, this).open();
        });
        return i;
    }

    private BukkitRunnable getUpdater() {
        return new BukkitRunnable(){
            int i = 0;

            public void run() {
                ArrayList<Material> recipe = Guide.this.getRecipe(this.i);
                Guide.this.addItem(15, Guide.this.createRecipeGuideIcon(recipe.getFirst(), "&cRecipes", " &8\u2022 Try different items and materials like:\n   &8- &a" + Utils.prettify(recipe.getFirst().toString()) + "\n   &8- &a" + Utils.prettify(recipe.get(1).toString())));
                if (this.i > 100000) {
                    this.i = 0;
                }
                ++this.i;
            }
        };
    }
}

