/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.gui;

import mc.obliviate.inventory.Icon;
import net.pullolo.aetheriumItems.gui.Guide;
import net.pullolo.aetheriumItems.gui.MagicAnvil;
import net.pullolo.aetheriumItems.gui.ScrollCrafting;
import net.pullolo.aetheriumItems.gui.ScrollRefining;
import net.pullolo.aetheriumItems.gui.base.BaseGui;
import net.pullolo.aetheriumItems.utils.Utils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.jetbrains.annotations.NotNull;

public class MainMenu
extends BaseGui {
    public MainMenu(@NotNull Player player) {
        super(player, "aei-main", "Forgery", 3);
    }

    @Override
    public void onOpen(InventoryOpenEvent event) {
        super.onOpen(event);
        this.fillGui(this.createFiller());
        this.addItem(10, this.createAnvilIcon());
        this.addItem(12, this.createScrollCraftingIcon());
        this.addItem(14, this.createScrollCreationIcon());
        this.addItem(16, this.createGuideIcon());
    }

    private Icon createAnvilIcon() {
        Icon i = new Icon(Material.ANVIL);
        i.setName(Utils.translate("&bMagic Anvil"));
        i.onClick((InventoryClickEvent click) -> {
            this.getInventory().close();
            new MagicAnvil(this.owner, this).open();
        });
        return i;
    }

    private Icon createScrollCraftingIcon() {
        Icon i = new Icon(Material.WRITABLE_BOOK);
        i.setName(Utils.translate("&dScroll Crafting"));
        i.onClick((InventoryClickEvent click) -> {
            this.getInventory().close();
            new ScrollCrafting(this.owner, this).open();
        });
        return i;
    }

    private Icon createScrollCreationIcon() {
        Icon i = new Icon(Material.BOOK);
        i.setName(Utils.translate("&aBook refining"));
        i.onClick((InventoryClickEvent click) -> {
            this.getInventory().close();
            new ScrollRefining(this.owner, this).open();
        });
        return i;
    }

    private Icon createGuideIcon() {
        Icon i = new Icon(Material.PAPER);
        i.setName(Utils.translate("&eGuide"));
        i.onClick((InventoryClickEvent click) -> {
            this.getInventory().close();
            new Guide(this.owner, this).open();
        });
        return i;
    }
}

