/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.gui;

import java.util.ArrayList;
import mc.obliviate.inventory.Gui;
import mc.obliviate.inventory.Icon;
import mc.obliviate.inventory.pagination.PaginationManager;
import net.pullolo.aetheriumItems.gui.SingleRecipeGui;
import net.pullolo.aetheriumItems.gui.base.BaseBackGui;
import net.pullolo.aetheriumItems.scrolls.PassiveAbility;
import net.pullolo.aetheriumItems.scrolls.Recipes;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import net.pullolo.aetheriumItems.utils.Utils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.jetbrains.annotations.NotNull;

public class RecipesGui
extends BaseBackGui {
    private final PaginationManager pagination = new PaginationManager(this);
    private final ArrayList<ArrayList<Material>> allRecipes = new ArrayList<ArrayList<Material>>(Recipes.scrollRecipes.keySet());

    public RecipesGui(@NotNull Player player, Gui prevGui) {
        super(player, "aei-recipes", "Recipes", 3, prevGui);
        this.pagination.registerPageSlotsBetween(9, 17);
    }

    @Override
    public void onOpen(InventoryOpenEvent event) {
        super.onOpen(event);
        this.fillGui(this.createFiller());
        this.calcAndUpdatePagination();
        this.addItem(0, new Icon(Material.ARROW).setName(Utils.translate("&7< Previous Page")).onClick((InventoryClickEvent e) -> {
            this.pagination.goPreviousPage();
            this.calcAndUpdatePagination();
        }));
        this.addItem(8, new Icon(Material.ARROW).setName(Utils.translate("&7Next Page >")).onClick((InventoryClickEvent e) -> {
            this.pagination.goNextPage();
            this.calcAndUpdatePagination();
        }));
        this.addItem(18, this.createBackItem());
    }

    private void calcAndUpdatePagination() {
        this.pagination.getItems().clear();
        for (ArrayList<Material> recipe : this.allRecipes) {
            this.pagination.addItem(this.createItemIcon(Recipes.scrollRecipes.get(recipe), recipe));
        }
        this.pagination.update();
    }

    private Icon createItemIcon(Scroll scroll, ArrayList<Material> recipe) {
        Icon icon = new Icon(recipe.getFirst());
        icon.setName(Utils.translate("&b" + Utils.prettify(scroll.getName())));
        ArrayList<String> base = scroll instanceof PassiveAbility && scroll.isOnlyPassive() ? ((PassiveAbility)((Object)scroll)).getPassiveDescription() : scroll.getDescription();
        ArrayList<String> desc = new ArrayList<String>();
        for (String s : base) {
            s = Utils.translate("&7" + s);
            desc.add(s);
        }
        icon.setLore(desc);
        icon.onClick((InventoryClickEvent click) -> {
            if (!click.isLeftClick()) {
                return;
            }
            this.getInventory().close();
            new SingleRecipeGui(this.owner, this, scroll, recipe).open();
        });
        return icon;
    }
}

