/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.gui;

import java.util.ArrayList;
import java.util.Arrays;
import mc.obliviate.inventory.Gui;
import mc.obliviate.inventory.Icon;
import mc.obliviate.inventory.advancedslot.AdvancedSlot;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.pullolo.aetheriumItems.gui.base.BaseCraftingGui;
import net.pullolo.aetheriumItems.items.Item;
import net.pullolo.aetheriumItems.scrolls.Recipes;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import net.pullolo.aetheriumItems.utils.Utils;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ScrollCrafting
extends BaseCraftingGui {
    private boolean is1Ok = false;
    private boolean is2Ok = false;
    private boolean is3Ok = false;
    private boolean oneWasCorrect = false;

    public ScrollCrafting(@NotNull Player player, Gui prevGui) {
        super(player, "aei-sc", "Scroll Crafting", 3, prevGui);
    }

    @Override
    public void onOpen(InventoryOpenEvent e) {
        this.fillGui(this.createFiller());
        this.addItem(18, this.createBackItem());
        this.updateUi();
        AdvancedSlot ing1 = this.advancedSlotManager.addAdvancedIcon(10, new Icon(Material.AIR));
        AdvancedSlot ing2 = this.advancedSlotManager.addAdvancedIcon(11, new Icon(Material.AIR));
        AdvancedSlot ing3 = this.advancedSlotManager.addAdvancedIcon(12, new Icon(Material.AIR));
        AdvancedSlot result = this.advancedSlotManager.addAdvancedIcon(16, new Icon(Material.BARRIER));
        result.onPrePutClick((event, item) -> true);
        result.getDisplayIcon().onClick((InventoryClickEvent click) -> this.getResult());
        ing1.onPut((event, item) -> {
            if (item == null) {
                return;
            }
            if (!item.getType().toString().toLowerCase().contains("_banner_pattern")) {
                return;
            }
            Item i = new Item((ItemStack)item);
            if (!i.isCustomItem()) {
                return;
            }
            if (i.hasScroll()) {
                return;
            }
            this.is1Ok = true;
            this.updateUi();
        });
        ing1.onPickup((event, item) -> {
            this.is1Ok = false;
            this.updateUi();
        });
        ing2.onPut((event, item) -> {
            if (item == null) {
                return;
            }
            for (ArrayList<Material> materials : Recipes.scrollRecipes.keySet()) {
                if (!materials.contains(item.getType())) continue;
                this.is2Ok = true;
                this.updateUi();
                return;
            }
        });
        ing2.onPickup((event, item) -> {
            this.is2Ok = false;
            if (this.oneWasCorrect) {
                this.oneWasCorrect = false;
                this.is3Ok = true;
            }
            this.updateUi();
        });
        ing3.onPut((event, item) -> {
            if (item == null) {
                return;
            }
            for (ArrayList<Material> materials : Recipes.scrollRecipes.keySet()) {
                if (!materials.contains(item.getType())) continue;
                this.is3Ok = true;
                this.updateUi();
                return;
            }
        });
        ing3.onPickup((event, item) -> {
            this.is3Ok = false;
            if (this.oneWasCorrect) {
                this.oneWasCorrect = false;
                this.is2Ok = true;
            }
            this.updateUi();
        });
    }

    private void updateUi() {
        boolean incorrectRecipe = true;
        if (this.is2Ok && this.is3Ok) {
            for (ArrayList<Material> materials : Recipes.scrollRecipes.keySet()) {
                if (!materials.contains(this.getInventory().getItem(11).getType()) || !materials.contains(this.getInventory().getItem(12).getType())) continue;
                incorrectRecipe = false;
                break;
            }
            if (incorrectRecipe) {
                this.oneWasCorrect = true;
                this.is2Ok = false;
                this.is3Ok = false;
            }
        }
        this.addItem(19, this.createSlotScrollIndicatorIcon(this.is1Ok));
        this.addItem(20, this.createSlotIndicatorIcon(this.is2Ok));
        this.addItem(21, this.createSlotIndicatorIcon(this.is3Ok));
        this.addItem(14, this.createCraftButton());
    }

    private void getResult() {
        ItemStack resultSlot = this.getInventory().getItem(16);
        if (resultSlot == null) {
            return;
        }
        if (resultSlot.getType().equals((Object)Material.BARRIER)) {
            return;
        }
        if (Arrays.asList(this.owner.getInventory().getStorageContents()).contains(null)) {
            this.owner.getInventory().addItem(new ItemStack[]{resultSlot});
        } else {
            this.owner.getWorld().dropItem(this.owner.getLocation(), resultSlot);
        }
        this.getInventory().setItem(16, new ItemStack(Material.BARRIER));
        this.updateUi();
    }

    private Icon createCraftButton() {
        Icon i = new Icon(Material.CRAFTING_TABLE);
        i.setName(Utils.translate("&d\u2727 Scroll Crafting"));
        ArrayList<String> lore = new ArrayList<String>();
        if (this.is1Ok && this.is2Ok && this.is3Ok) {
            lore.add(Utils.translate(" &eLeft Click &7to craft."));
        } else {
            lore.add(Utils.translate(" &cInvalid Recipe."));
        }
        i.setLore(lore);
        i.onClick((InventoryClickEvent click) -> {
            if (!click.isLeftClick()) {
                return;
            }
            if (!(this.is1Ok && this.is2Ok && this.is3Ok)) {
                this.owner.playSound((Entity)this.owner, Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                return;
            }
            this.getResult();
            ItemStack scrollSlot = this.getInventory().getItem(10);
            if (scrollSlot == null) {
                return;
            }
            if (!scrollSlot.getType().toString().toLowerCase().contains("_banner_pattern") || !new Item(scrollSlot).isCustomItem() || new Item(scrollSlot).hasScroll()) {
                return;
            }
            ArrayList<Material> recipe = this.getRecipe();
            Scroll resultScroll = Recipes.scrollRecipes.get(recipe);
            ItemStack scrollItem = scrollSlot.clone();
            ItemStack item1Slot = this.getInventory().getItem(11);
            if (item1Slot == null) {
                return;
            }
            if (!recipe.contains(item1Slot.getType())) {
                return;
            }
            ItemStack item2Slot = this.getInventory().getItem(12);
            if (item2Slot == null) {
                return;
            }
            if (!recipe.contains(item2Slot.getType())) {
                return;
            }
            scrollSlot.setAmount(scrollSlot.getAmount() - 1);
            this.getInventory().setItem(10, scrollSlot);
            item1Slot.setAmount(item1Slot.getAmount() - 1);
            this.getInventory().setItem(11, item1Slot);
            item2Slot.setAmount(item2Slot.getAmount() - 1);
            this.getInventory().setItem(12, item2Slot);
            this.owner.playSound((Entity)this.owner, Sound.BLOCK_ANVIL_USE, 1.0f, 2.0f);
            this.owner.playSound((Entity)this.owner, Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.4f);
            Item s = new Item(scrollItem);
            s.convert("scroll");
            s.changeName(((TextComponent)Component.text((String)(resultScroll.getName() + " Scroll")).color(TextColor.color((int)26, (int)228, (int)255))).decoration(TextDecoration.ITALIC, false));
            s.addScroll(resultScroll);
            s.generateDescription(null);
            this.getInventory().setItem(16, s.getItemStack());
            if (scrollSlot.getAmount() < 1) {
                this.is1Ok = false;
            }
            if (item1Slot.getAmount() < 1) {
                this.is2Ok = false;
            }
            if (item2Slot.getAmount() < 1) {
                this.is3Ok = false;
            }
            this.updateUi();
        });
        return i;
    }

    private ArrayList<Material> getRecipe() {
        for (ArrayList<Material> materials : Recipes.scrollRecipes.keySet()) {
            if (!materials.contains(this.getInventory().getItem(11).getType()) || !materials.contains(this.getInventory().getItem(12).getType())) continue;
            return materials;
        }
        return new ArrayList<Material>();
    }
}

