/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import mc.obliviate.inventory.Gui;
import mc.obliviate.inventory.Icon;
import mc.obliviate.inventory.advancedslot.AdvancedSlot;
import net.pullolo.aetheriumItems.gui.base.BaseCraftingGui;
import net.pullolo.aetheriumItems.items.Item;
import net.pullolo.aetheriumItems.utils.Utils;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ScrollRefining
extends BaseCraftingGui {
    private boolean is1Ok = false;
    private boolean is2Ok = false;

    public ScrollRefining(@NotNull Player player, Gui prevGui) {
        super(player, "aei-sr", "Scroll Refining", 3, prevGui);
    }

    @Override
    public void onOpen(InventoryOpenEvent e) {
        this.fillGui(this.createFiller());
        this.addItem(18, this.createBackItem());
        this.updateUi();
        AdvancedSlot ing1 = this.advancedSlotManager.addAdvancedIcon(10, new Icon(Material.AIR));
        AdvancedSlot ing2 = this.advancedSlotManager.addAdvancedIcon(12, new Icon(Material.AIR));
        AdvancedSlot result = this.advancedSlotManager.addAdvancedIcon(16, new Icon(Material.BARRIER));
        result.onPrePutClick((event, item) -> true);
        result.getDisplayIcon().onClick((InventoryClickEvent click) -> this.getResult());
        ing1.onPut((event, item) -> {
            if (item == null) {
                return;
            }
            if (!item.getType().equals((Object)Material.BOOK)) {
                return;
            }
            this.is1Ok = true;
            this.updateUi();
        });
        ing1.onPickup((event, item) -> {
            this.is1Ok = false;
            this.updateUi();
        });
        ing2.onPut((event, item) -> {
            if (item == null) {
                return;
            }
            if (!item.getType().equals((Object)Material.ECHO_SHARD)) {
                return;
            }
            this.is2Ok = true;
            this.updateUi();
        });
        ing2.onPickup((event, item) -> {
            this.is2Ok = false;
            this.updateUi();
        });
    }

    private void getResult() {
        ItemStack resultSlot = this.getInventory().getItem(16);
        if (resultSlot == null) {
            return;
        }
        if (resultSlot.getType().equals((Object)Material.BARRIER)) {
            return;
        }
        if (Arrays.asList(this.owner.getInventory().getStorageContents()).contains(null)) {
            this.owner.getInventory().addItem(new ItemStack[]{resultSlot});
        } else {
            this.owner.getWorld().dropItem(this.owner.getLocation(), resultSlot);
        }
        this.getInventory().setItem(16, new ItemStack(Material.BARRIER));
        this.updateUi();
    }

    private void updateUi() {
        this.addItem(19, this.createSlotIndicatorIcon(this.is1Ok));
        this.addItem(21, this.createSlotIndicatorIcon(this.is2Ok));
        this.addItem(14, this.createCraftButton());
    }

    private Icon createCraftButton() {
        Icon i = new Icon(Material.ENCHANTING_TABLE);
        i.setName(Utils.translate("&b\u2727 Book Refining"));
        ArrayList<String> lore = new ArrayList<String>();
        if (this.is1Ok && this.is2Ok) {
            lore.add(Utils.translate(" &eLeft Click &7to refine."));
        } else {
            lore.add(Utils.translate(" &cInvalid Recipe."));
        }
        i.setLore(lore);
        i.onClick((InventoryClickEvent click) -> {
            if (!click.isLeftClick()) {
                return;
            }
            if (!this.is1Ok || !this.is2Ok) {
                this.owner.playSound((Entity)this.owner, Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                return;
            }
            this.getResult();
            ItemStack bookSlot = this.getInventory().getItem(10);
            if (bookSlot == null) {
                return;
            }
            if (!bookSlot.getType().equals((Object)Material.BOOK)) {
                return;
            }
            ItemStack echoSlot = this.getInventory().getItem(12);
            if (echoSlot == null) {
                return;
            }
            if (!echoSlot.getType().equals((Object)Material.ECHO_SHARD)) {
                return;
            }
            bookSlot.setAmount(bookSlot.getAmount() - 1);
            this.getInventory().setItem(10, bookSlot);
            echoSlot.setAmount(echoSlot.getAmount() - 1);
            this.getInventory().setItem(12, echoSlot);
            this.owner.playSound((Entity)this.owner, Sound.BLOCK_ANVIL_USE, 1.0f, 2.0f);
            if (new Random().nextInt(4) == 0) {
                this.owner.playSound((Entity)this.owner, Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.4f);
                this.getInventory().setItem(16, Item.createNewScroll().getItemStack());
            } else {
                this.owner.playSound((Entity)this.owner, Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                this.getInventory().setItem(16, new ItemStack(Material.BOOK, 1));
            }
            if (bookSlot.getAmount() < 1) {
                this.is1Ok = false;
            }
            if (echoSlot.getAmount() < 1) {
                this.is2Ok = false;
            }
            this.updateUi();
        });
        return i;
    }
}

