/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.gui;

import java.util.ArrayList;
import mc.obliviate.inventory.Gui;
import mc.obliviate.inventory.Icon;
import net.pullolo.aetheriumItems.gui.base.BaseBackGui;
import net.pullolo.aetheriumItems.scrolls.PassiveAbility;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import net.pullolo.aetheriumItems.utils.Utils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.jetbrains.annotations.NotNull;

public class SingleRecipeGui
extends BaseBackGui {
    private final Scroll scroll;
    private final ArrayList<Material> recipe;

    public SingleRecipeGui(@NotNull Player player, Gui prevGui, Scroll s, ArrayList<Material> recipe) {
        super(player, "aei-single-recipe", Utils.prettify(s.getName()), 3, prevGui);
        this.recipe = recipe;
        this.scroll = s;
    }

    @Override
    public void onOpen(InventoryOpenEvent event) {
        super.onOpen(event);
        this.fillGui(this.createFiller());
        this.addItem(11, this.createEmptyScrollIcon());
        this.addItem(12, this.createMaterialIcon(this.recipe.getFirst()));
        this.addItem(13, this.createMaterialIcon(this.recipe.get(1)));
        this.addItem(15, this.createProductIcon());
        this.addItem(18, this.createBackItem());
    }

    private Icon createProductIcon() {
        Icon i = new Icon(Material.CREEPER_BANNER_PATTERN);
        i.setName(Utils.translate("&b" + Utils.prettify(this.scroll.getName())));
        ArrayList<String> base = this.scroll instanceof PassiveAbility && this.scroll.isOnlyPassive() ? ((PassiveAbility)((Object)this.scroll)).getPassiveDescription() : this.scroll.getDescription();
        ArrayList<String> desc = new ArrayList<String>();
        for (String s : base) {
            s = Utils.translate("&7" + s);
            desc.add(s);
        }
        i.setLore(desc);
        return i;
    }

    private Icon createEmptyScrollIcon() {
        Icon i = new Icon(Material.CREEPER_BANNER_PATTERN);
        i.setName(Utils.translate("&bBlank Scroll"));
        return i;
    }

    private Icon createMaterialIcon(Material m) {
        Icon i = new Icon(m);
        i.setName(Utils.translate("&f" + Utils.prettify(m.toString())));
        return i;
    }
}

