/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.items;

import java.util.ArrayList;
import java.util.Random;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.pullolo.aetheriumItems.AetheriumItems;
import net.pullolo.aetheriumItems.ModifiableItems;
import net.pullolo.aetheriumItems.scrolls.PassiveAbility;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Item {
    private final ItemStack itemStack;
    private final NamespacedKey itemIdKey;
    private final NamespacedKey scrollKey;
    private final NamespacedKey originalLoreKey;

    public static Item createNewScroll() {
        ItemStack item = new ItemStack(Item.getRandomBannerPattern());
        ItemMeta meta = item.getItemMeta();
        meta.itemName(((TextComponent)Component.text((String)"Blank Scroll").color(TextColor.color((int)26, (int)228, (int)255))).decoration(TextDecoration.ITALIC, false));
        item.setItemMeta(meta);
        Item i = new Item(item);
        i.convert("scroll");
        return i;
    }

    public Item(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.itemIdKey = new NamespacedKey((Plugin)AetheriumItems.aetheriumItemsPlugin, "aetherium-items-id");
        this.scrollKey = new NamespacedKey((Plugin)AetheriumItems.aetheriumItemsPlugin, "aetherium-items-scroll");
        this.originalLoreKey = new NamespacedKey((Plugin)AetheriumItems.aetheriumItemsPlugin, "aetherium-items-original-lore");
    }

    public void convert(String itemId) {
        if (this.itemStack.getAmount() > 1) {
            AetheriumItems.logWarning("Plugin tried to convert more than 1 item, check config.yml!");
            return;
        }
        if (!ModifiableItems.canBeConverted(this.itemStack) && !itemId.equalsIgnoreCase("scroll")) {
            AetheriumItems.logWarning("Plugin tried to convert illegal item!");
            return;
        }
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta.getPersistentDataContainer().has(this.itemIdKey)) {
            return;
        }
        meta.getPersistentDataContainer().set(this.itemIdKey, PersistentDataType.STRING, (Object)itemId);
        this.itemStack.setItemMeta(meta);
    }

    public void addScroll(Scroll s) {
        if (this.itemStack.getAmount() > 1) {
            AetheriumItems.logWarning("Plugin tried to convert more than 1 item, check config.yml!");
            return;
        }
        if (!ModifiableItems.canBeConverted(this.itemStack) && !this.getItemId().equalsIgnoreCase("scroll")) {
            AetheriumItems.logWarning("Plugin tried to convert illegal item!");
            return;
        }
        ItemMeta meta = this.itemStack.getItemMeta();
        if (!meta.getPersistentDataContainer().has(this.itemIdKey)) {
            AetheriumItems.logWarning("Plugin tried to add scroll to non converted item!");
            return;
        }
        if (ModifiableItems.isArmor(this.itemStack)) {
            AetheriumItems.logWarning("Plugin tried to add scroll to an armor piece!");
            return;
        }
        if (this.hasScroll()) {
            AetheriumItems.logWarning("Plugin tried to add a second scroll!");
            return;
        }
        meta.getPersistentDataContainer().set(this.scrollKey, PersistentDataType.STRING, (Object)s.getType());
        this.itemStack.setItemMeta(meta);
    }

    public boolean isCustomItem() {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(this.itemIdKey);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean hasScroll() {
        ItemMeta meta = this.itemStack.getItemMeta();
        return meta.getPersistentDataContainer().has(this.scrollKey);
    }

    public String getItemId() {
        ItemMeta meta = this.itemStack.getItemMeta();
        return (String)this.itemStack.getPersistentDataContainer().get(this.itemIdKey, PersistentDataType.STRING);
    }

    public Scroll getScroll() {
        ItemMeta meta = this.itemStack.getItemMeta();
        return Scroll.getScroll((String)meta.getPersistentDataContainer().get(this.scrollKey, PersistentDataType.STRING));
    }

    public void generateDescription(String player) {
        ItemMeta meta = this.itemStack.getItemMeta();
        ArrayList<Object> lore = new ArrayList<Object>();
        if (this.itemStack.getPersistentDataContainer().has(this.originalLoreKey)) {
            String[] originalLore = ((String)this.itemStack.getPersistentDataContainer().get(this.originalLoreKey, PersistentDataType.STRING)).split("\n");
            for (String s : originalLore) {
                lore.add(((TextComponent)Component.text((String)s).color(TextColor.fromHexString((String)"#AAAAAA"))).decoration(TextDecoration.ITALIC, false));
            }
        }
        if (this.hasScroll()) {
            lore.add(Component.text((String)""));
        }
        if (this.hasScroll() && !this.getScroll().isOnlyPassive()) {
            Scroll s = this.getScroll();
            lore.add(((TextComponent)((TextComponent)Component.text((String)("Active Ability: " + s.getName())).color(TextColor.fromHexString((String)"#FFAA00"))).decoration(TextDecoration.ITALIC, false)).append(((TextComponent)((TextComponent)Component.text((String)(ModifiableItems.isRange(this.itemStack) ? " LEFT CLICK" : " RIGHT CLICK")).color(TextColor.fromHexString((String)"#FFFF55"))).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false)));
            for (String str : s.getDescription()) {
                lore.add(((TextComponent)Component.text((String)str).color(TextColor.fromHexString((String)"#AAAAAA"))).decoration(TextDecoration.ITALIC, false));
            }
            lore.add(((TextComponent)((TextComponent)Component.text((String)"Cooldown: ").color(TextColor.fromHexString((String)"#555555"))).decoration(TextDecoration.ITALIC, false)).append(((TextComponent)Component.text((String)(s.getCooldown() + "s")).color(TextColor.fromHexString((String)"#55FF55"))).decoration(TextDecoration.ITALIC, false)));
            lore.add(Component.text((String)""));
        }
        if (this.hasScroll() && this.getScroll() instanceof PassiveAbility) {
            lore.add(((TextComponent)Component.text((String)"Passive Ability").color(TextColor.fromHexString((String)"#339bff"))).decoration(TextDecoration.ITALIC, false));
            for (String str : ((PassiveAbility)((Object)this.getScroll())).getPassiveDescription()) {
                lore.add(((TextComponent)Component.text((String)str).color(TextColor.fromHexString((String)"#AAAAAA"))).decoration(TextDecoration.ITALIC, false));
            }
            lore.add(Component.text((String)""));
        }
        if (player != null) {
            lore.add(((TextComponent)((TextComponent)Component.text((String)"Obtained by ").color(TextColor.fromHexString((String)"#606060"))).decoration(TextDecoration.ITALIC, false)).append(((TextComponent)Component.text((String)player).color(TextColor.fromHexString((String)"#00ff5c"))).decoration(TextDecoration.ITALIC, false)));
        }
        meta.lore(lore);
        this.itemStack.setItemMeta(meta);
    }

    public void saveOriginalLore() {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta.getPersistentDataContainer().has(this.originalLoreKey)) {
            AetheriumItems.logWarning("Lore already saved!");
            return;
        }
        if (!meta.hasLore()) {
            return;
        }
        StringBuilder lore = new StringBuilder();
        for (Component c : meta.lore()) {
            if (!(c instanceof TextComponent)) continue;
            lore.append(((TextComponent)c).content()).append("\n");
        }
        meta.getPersistentDataContainer().set(this.originalLoreKey, PersistentDataType.STRING, (Object)lore.toString());
        this.itemStack.setItemMeta(meta);
    }

    private static Material getRandomBannerPattern() {
        ArrayList<Material> banners = new ArrayList<Material>();
        for (Material m : Material.values()) {
            if (!m.toString().toLowerCase().contains("_banner_pattern")) continue;
            banners.add(m);
        }
        return (Material)banners.get(new Random().nextInt(banners.size()));
    }

    public void changeName(Component c) {
        ItemMeta meta = this.itemStack.getItemMeta();
        meta.itemName(c);
        this.itemStack.setItemMeta(meta);
    }
}

