/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.scrolls;

import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.pullolo.aetheriumItems.scrolls.custom.BleedingScroll;
import net.pullolo.aetheriumItems.scrolls.custom.DayScroll;
import net.pullolo.aetheriumItems.scrolls.custom.DragonSkinScroll;
import net.pullolo.aetheriumItems.scrolls.custom.EndermanScroll;
import net.pullolo.aetheriumItems.scrolls.custom.FrostNovaScroll;
import net.pullolo.aetheriumItems.scrolls.custom.HasteScroll;
import net.pullolo.aetheriumItems.scrolls.custom.LaserScroll;
import net.pullolo.aetheriumItems.scrolls.custom.ShadowstepScroll;
import net.pullolo.aetheriumItems.scrolls.custom.ShriekScroll;
import net.pullolo.aetheriumItems.scrolls.custom.TreecapitatorScroll;
import net.pullolo.aetheriumItems.scrolls.custom.WeatherScroll;
import net.pullolo.aetheriumItems.scrolls.custom.WindScroll;
import org.bukkit.entity.Player;

public abstract class Scroll {
    protected String name;
    protected String type;
    protected ArrayList<String> description = new ArrayList();
    protected int cooldown;
    protected boolean onlyPassive;

    public abstract void executeAbility(Player var1);

    public static Scroll getScroll(String type) {
        switch (type) {
            case "wind": {
                return new WindScroll();
            }
            case "shriek": {
                return new ShriekScroll();
            }
            case "day": {
                return new DayScroll();
            }
            case "weather": {
                return new WeatherScroll();
            }
            case "dragon_skin": {
                return new DragonSkinScroll();
            }
            case "enderman": {
                return new EndermanScroll();
            }
            case "haste": {
                return new HasteScroll();
            }
            case "treecapitator": {
                return new TreecapitatorScroll();
            }
            case "bleeding": {
                return new BleedingScroll();
            }
            case "laser": {
                return new LaserScroll();
            }
            case "frost_nova": {
                return new FrostNovaScroll();
            }
            case "shadowstep": {
                return new ShadowstepScroll();
            }
        }
        return new Scroll(){

            @Override
            public void executeAbility(Player p) {
                p.sendMessage("No ability found!");
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public ArrayList<String> getDescription() {
        return this.description;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void onCooldownInfo(Player p, long time) {
        String s = (float)((int)time / 100) / 10.0f == 0.0f ? "0.1" : "" + (float)((int)time / 100) / 10.0f;
        p.sendActionBar(((TextComponent)Component.text((String)("On cooldown for " + s + "s.")).color(TextColor.color((int)255, (int)0, (int)0))).decoration(TextDecoration.ITALIC, false));
    }

    public boolean isOnlyPassive() {
        return this.onlyPassive;
    }
}

