/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.scrolls.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.pullolo.aetheriumItems.AetheriumItems;
import net.pullolo.aetheriumItems.items.Item;
import net.pullolo.aetheriumItems.scrolls.PassiveAbility;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BleedingScroll
extends Scroll
implements PassiveAbility,
Listener {
    private final Map<UUID, BleedData> bleedingTargets = new HashMap<UUID, BleedData>();

    public BleedingScroll() {
        this.type = "bleeding";
        this.name = "Bleeding";
        this.onlyPassive = true;
    }

    @EventHandler
    public void onEntityHit(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity2;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (!item.hasItemMeta()) {
            return;
        }
        Item customItem = new Item(item);
        if (!(customItem.isCustomItem() && customItem.hasScroll() && customItem.getScroll() instanceof BleedingScroll)) {
            return;
        }
        UUID targetId = target.getUniqueId();
        BleedData data = this.bleedingTargets.getOrDefault(targetId, new BleedData());
        data.stack = Math.min(data.stack + 1, 3);
        data.resetTimer();
        if (!data.active) {
            data.active = true;
            this.startBleedTask(target, targetId);
        }
        this.bleedingTargets.put(targetId, data);
    }

    private void startBleedTask(final LivingEntity entity, final UUID id) {
        new BukkitRunnable(){

            public void run() {
                BleedData data = BleedingScroll.this.bleedingTargets.get(id);
                if (data == null || !data.active) {
                    this.cancel();
                    return;
                }
                if (entity.isDead()) {
                    BleedingScroll.this.bleedingTargets.remove(id);
                    this.cancel();
                    return;
                }
                if (--data.duration <= 0) {
                    BleedingScroll.this.bleedingTargets.remove(id);
                    this.cancel();
                    return;
                }
                entity.damage((double)data.stack);
                AetheriumItems.particleApi.spawnColoredParticles(entity.getLocation().add(0.0, 1.0, 0.0), Color.RED, 1.0f, 25 * data.stack, 0.2, 0.4, 0.2);
            }
        }.runTaskTimer((Plugin)AetheriumItems.aetheriumItemsPlugin, 20L, 20L);
    }

    @Override
    public void executeAbility(Player p) {
    }

    @Override
    public void onApply(Player player) {
    }

    @Override
    public void onRemove(Player player) {
    }

    @Override
    public ArrayList<String> getPassiveDescription() {
        ArrayList<String> description = new ArrayList<String>();
        description.add("Applies bleeding to attacked enemies.");
        description.add("Stacks max 3 times.");
        return description;
    }

    private static class BleedData {
        int stack = 0;
        int duration = 3;
        boolean active = false;

        private BleedData() {
        }

        void resetTimer() {
            this.duration = 3;
        }
    }
}

