/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.scrolls.custom;

import net.pullolo.aetheriumItems.AetheriumItems;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import net.pullolo.aetheriumItems.utils.CooldownApi;
import net.pullolo.aetheriumItems.utils.Utils;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class DayScroll
extends Scroll {
    public DayScroll() {
        this.type = "day";
        this.name = "Day Control";
        this.description.add("Switch world time between day and night.");
        this.cooldown = 1200;
    }

    @Override
    public void executeAbility(final Player p) {
        if (CooldownApi.isOnCooldown("day-scroll", p)) {
            this.onCooldownInfo(p, CooldownApi.getCooldownForPlayerLong("day-scroll", p));
            return;
        }
        p.getWorld().playSound(p.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_RESONATE, 1.0f, 0.8f);
        new BukkitRunnable(this){
            int i = 0;

            public void run() {
                if (this.i > 60) {
                    this.cancel();
                    return;
                }
                Location l = p.getLocation().clone().add(0.0, 2.0, 0.0).subtract(0.0, (double)this.i / 50.0, 0.0).add(Utils.rotateVector(new Vector(1, 0, 0), this.i * 20));
                AetheriumItems.particleApi.spawnColoredParticles(l, Color.YELLOW, 1.0f, 2, 0.1, 0.1, 0.1);
                ++this.i;
            }
        }.runTaskTimer((Plugin)AetheriumItems.aetheriumItemsPlugin, 0L, 2L);
        p.getWorld().setTime(this.isDay(p.getWorld()) ? 18000L : 6000L);
        CooldownApi.addCooldown("day-scroll", p, this.cooldown);
    }

    public boolean isDay(World w) {
        long time = w.getTime();
        return time < 12300L || time > 23850L;
    }
}

