/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.scrolls.custom;

import java.util.ArrayList;
import net.pullolo.aetheriumItems.AetheriumItems;
import net.pullolo.aetheriumItems.scrolls.PassiveAbility;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import net.pullolo.aetheriumItems.utils.CooldownApi;
import org.bukkit.Color;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DragonSkinScroll
extends Scroll
implements PassiveAbility {
    public DragonSkinScroll() {
        this.type = "dragon_skin";
        this.name = "Dragon Skin";
        this.description.add("Makes you immune to fire damage for 60s.");
        this.cooldown = 480;
    }

    @Override
    public void executeAbility(Player p) {
        if (CooldownApi.isOnCooldown("dragon-skin-scroll", p)) {
            this.onCooldownInfo(p, CooldownApi.getCooldownForPlayerLong("dragon-skin-scroll", p));
            return;
        }
        p.getWorld().playSound(p.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_RESONATE, 1.0f, 0.8f);
        AetheriumItems.particleApi.spawnColoredParticles(p.getLocation().add(0.0, 1.0, 0.0), Color.RED, 1.0f, 30, 1.0, 1.0, 1.0);
        p.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 1200, 0));
        CooldownApi.addCooldown("dragon-skin-scroll", p, this.cooldown);
    }

    @Override
    public void onApply(Player player) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, Integer.MAX_VALUE, 0, false, false));
    }

    @Override
    public void onRemove(Player player) {
        player.removePotionEffect(PotionEffectType.RESISTANCE);
    }

    @Override
    public ArrayList<String> getPassiveDescription() {
        ArrayList<String> description = new ArrayList<String>();
        description.add("Holding this item gives you permanent resistance.");
        return description;
    }
}

