/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.scrolls.custom;

import java.util.ArrayList;
import net.pullolo.aetheriumItems.items.Item;
import net.pullolo.aetheriumItems.scrolls.PassiveAbility;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.inventory.ItemStack;

public class EndermanScroll
extends Scroll
implements PassiveAbility,
Listener {
    public EndermanScroll() {
        this.type = "enderman";
        this.name = "Enderman";
        this.onlyPassive = true;
    }

    @EventHandler
    public void onEndermanTarget(EntityTargetLivingEntityEvent event) {
        if (!(event.getEntity() instanceof Enderman)) {
            return;
        }
        LivingEntity livingEntity = event.getTarget();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (!item.hasItemMeta()) {
            return;
        }
        Item customItem = new Item(item);
        if (!customItem.isCustomItem() || !customItem.hasScroll()) {
            return;
        }
        Scroll scroll = customItem.getScroll();
        if (!(scroll instanceof PassiveAbility)) {
            return;
        }
        if (scroll instanceof EndermanScroll) {
            event.setCancelled(true);
        }
    }

    @Override
    public void onApply(Player player) {
    }

    @Override
    public void onRemove(Player player) {
    }

    @Override
    public ArrayList<String> getPassiveDescription() {
        ArrayList<String> description = new ArrayList<String>();
        description.add("Makes you immune to Enderman aggro.");
        return description;
    }

    @Override
    public void executeAbility(Player p) {
    }
}

