/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.scrolls.custom;

import java.util.ArrayList;
import java.util.Random;
import net.pullolo.aetheriumItems.AetheriumItems;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import net.pullolo.aetheriumItems.utils.CooldownApi;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class FrostNovaScroll
extends Scroll {
    public FrostNovaScroll() {
        this.type = "frost_nova";
        this.name = "Frost Nova";
        this.cooldown = 15;
        this.description.add("Unleashes a powerful frost explosion");
        this.description.add("that damages and slows nearby enemies.");
    }

    @Override
    public void executeAbility(Player p) {
        if (CooldownApi.isOnCooldown("frost-nova-scroll", p)) {
            this.onCooldownInfo(p, CooldownApi.getCooldownForPlayerLong("frost-nova-scroll", p));
            return;
        }
        this.createFrostExplosion(p);
        CooldownApi.addCooldown("frost-nova-scroll", p, this.cooldown);
    }

    private void createFrostCrystal(Location location, Color[] colors, Random random, double size) {
        for (int i = 0; i < 10; ++i) {
            double angle = random.nextDouble() * Math.PI * 2.0;
            double height = random.nextDouble() * size;
            double x = Math.cos(angle) * size * 0.3;
            double z = Math.sin(angle) * size * 0.3;
            Location particleLoc = location.clone().add(x, height, z);
            Color color = colors[random.nextInt(colors.length)];
            AetheriumItems.particleApi.spawnColoredParticles(particleLoc, color, 1.0f, 1, 0.0, 0.0, 0.0);
        }
    }

    private void createFrostExplosion(final Player player) {
        final Location center = player.getLocation();
        final World world = player.getWorld();
        final ArrayList hitEntities = new ArrayList();
        world.playSound(center, Sound.BLOCK_GLASS_BREAK, 1.5f, 0.7f);
        world.playSound(center, Sound.BLOCK_AMETHYST_BLOCK_CHIME, 1.2f, 0.5f);
        final Color[] frostColors = new Color[]{Color.WHITE, Color.fromRGB((int)220, (int)240, (int)255), Color.fromRGB((int)190, (int)230, (int)255), Color.fromRGB((int)160, (int)210, (int)255), Color.fromRGB((int)130, (int)190, (int)255), Color.fromRGB((int)100, (int)170, (int)255), Color.AQUA};
        new BukkitRunnable(){
            final double maxRadius = 8.0;
            double radius = 0.5;
            int ticks = 0;
            final int slices = 3;
            final Random random = new Random();

            public void run() {
                if (this.radius >= 8.0 || this.ticks >= 20) {
                    this.cancel();
                    return;
                }
                for (double y = 0.0; y < 3.0; y += 1.0) {
                    double height = y * 0.4;
                    for (double angle = 0.0; angle < Math.PI * 2; angle += Math.PI / (32.0 + this.radius)) {
                        double x = Math.cos(angle) * this.radius;
                        double z = Math.sin(angle) * this.radius;
                        Location particleLoc = center.clone().add(x, height, z);
                        double offsetX = (this.random.nextDouble() - 0.5) * 0.2;
                        double offsetY = (this.random.nextDouble() - 0.5) * 0.05;
                        double offsetZ = (this.random.nextDouble() - 0.5) * 0.2;
                        particleLoc.add(offsetX, offsetY, offsetZ);
                        Color color = frostColors[this.random.nextInt(frostColors.length)];
                        AetheriumItems.particleApi.spawnColoredParticles(particleLoc, color, 1.0f, 1, 0.0, 0.0, 0.0);
                        if (!(this.radius > 2.0) || !(Math.abs(this.radius - particleLoc.distance(center)) < 0.5)) continue;
                        Color edgeColor = (new Color[]{Color.WHITE, Color.fromRGB((int)220, (int)240, (int)255)})[this.random.nextInt(2)];
                        AetheriumItems.particleApi.spawnColoredParticles(particleLoc, edgeColor, 1.0f, 1, 0.0, 0.0, 0.0);
                    }
                }
                if (this.ticks % 2 == 0) {
                    for (int i = 0; i < 8; ++i) {
                        double angle = this.random.nextDouble() * Math.PI * 2.0;
                        double dist = this.random.nextDouble() * this.radius;
                        FrostNovaScroll.this.createFrostCrystal(center.clone().add(Math.cos(angle) * dist, 0.3 + this.random.nextDouble() * 0.5, Math.sin(angle) * dist), frostColors, this.random, 0.3);
                    }
                }
                if (this.ticks % 3 == 0) {
                    double spikeAngle = this.random.nextDouble() * Math.PI * 2.0;
                    Location spikeLoc = center.clone().add(Math.cos(spikeAngle) * this.radius, 0.1, Math.sin(spikeAngle) * this.radius);
                    double spikeHeight = 0.8 + this.random.nextDouble() * 1.2;
                    for (double h = 0.0; h < spikeHeight; h += 0.1) {
                        double width = 0.15 * (1.0 - h / spikeHeight);
                        for (int i = 0; i < 3; ++i) {
                            double offsetX = (this.random.nextDouble() - 0.5) * width;
                            double offsetZ = (this.random.nextDouble() - 0.5) * width;
                            Location partLoc = spikeLoc.clone().add(offsetX, h, offsetZ);
                            Color color = h > spikeHeight * 0.7 ? Color.WHITE : frostColors[this.random.nextInt(frostColors.length)];
                            AetheriumItems.particleApi.spawnColoredParticles(partLoc, color, 1.0f, 1, 0.0, 0.0, 0.0);
                        }
                    }
                }
                if (this.ticks == 0 || this.ticks == 10) {
                    for (double angle = 0.0; angle < Math.PI * 2; angle += 0.7853981633974483) {
                        Location crystalLoc = center.clone().add(Math.cos(angle) * this.radius * 0.7, 0.5, Math.sin(angle) * this.radius * 0.7);
                        FrostNovaScroll.this.createFrostCrystal(crystalLoc, frostColors, this.random, 0.7);
                    }
                }
                double damageHeight = 2.0;
                for (Entity entity : world.getNearbyEntities(center, this.radius, damageHeight, this.radius)) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (entity == player || hitEntities.contains(entity)) continue;
                    hitEntities.add(livingEntity);
                    livingEntity.damage(10.0, (Entity)player);
                    livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 100, 2));
                    AetheriumItems.particleApi.spawnColoredParticles(livingEntity.getLocation().add(0.0, 1.0, 0.0), Color.WHITE, 1.0f, 20, 0.3, 0.3, 0.3);
                    world.playSound(livingEntity.getLocation(), Sound.BLOCK_GLASS_BREAK, 0.8f, 1.2f);
                    FrostNovaScroll.this.createFrostCrystal(livingEntity.getLocation().add(0.0, 1.0, 0.0), frostColors, this.random, 0.5);
                }
                if (this.ticks % 4 == 0) {
                    world.playSound(center, Sound.BLOCK_AMETHYST_BLOCK_CHIME, 0.5f, 0.5f + (float)this.radius / 10.0f);
                }
                this.radius += 0.4;
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)AetheriumItems.aetheriumItemsPlugin, 0L, 1L);
        new BukkitRunnable(this){
            final double maxRadius = 8.0;
            double radius = 0.2;
            int ticks = 0;

            public void run() {
                if (this.radius >= 8.0 || this.ticks >= 25) {
                    this.cancel();
                    return;
                }
                for (double angle = 0.0; angle < Math.PI * 2; angle += 0.19634954084936207) {
                    double x = Math.cos(angle) * this.radius;
                    double z = Math.sin(angle) * this.radius;
                    Location particleLoc = center.clone().add(x, 0.0, z);
                    particleLoc.add((new Random().nextDouble() - 0.5) * 0.3, 0.0, (new Random().nextDouble() - 0.5) * 0.3);
                    Location groundPos = particleLoc.clone();
                    while (groundPos.getBlock().getType() == Material.AIR && groundPos.getY() > 0.0) {
                        groundPos.subtract(0.0, 1.0, 0.0);
                    }
                    groundPos.add(0.0, 1.05, 0.0);
                    Color color = (new Color[]{Color.WHITE, Color.fromRGB((int)220, (int)240, (int)255), Color.fromRGB((int)200, (int)230, (int)255)})[new Random().nextInt(3)];
                    AetheriumItems.particleApi.spawnColoredParticles(groundPos, color, 1.0f, 1, 0.0, 0.0, 0.0);
                    if (new Random().nextInt(12) != 0) continue;
                    world.spawnParticle(Particle.SNOWFLAKE, groundPos.clone().add(0.0, 0.1, 0.0), 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.radius += 0.3;
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)AetheriumItems.aetheriumItemsPlugin, 0L, 1L);
    }
}

