/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.scrolls.custom;

import java.util.ArrayList;
import java.util.Random;
import net.pullolo.aetheriumItems.AetheriumItems;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import net.pullolo.aetheriumItems.utils.CooldownApi;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class LaserScroll
extends Scroll {
    public LaserScroll() {
        this.type = "laser";
        this.name = "Laser";
        this.cooldown = 10;
        this.description.add("Fires a powerful laser in the direction");
        this.description.add("you are looking at.");
    }

    @Override
    public void executeAbility(Player p) {
        if (CooldownApi.isOnCooldown("laser-scroll", p)) {
            this.onCooldownInfo(p, CooldownApi.getCooldownForPlayerLong("laser-scroll", p));
            return;
        }
        this.shootSpiralRay(p);
        CooldownApi.addCooldown("laser-scroll", p, this.cooldown);
    }

    public void shootSpiralRay(Player player) {
        Location start = player.getEyeLocation();
        Vector direction = start.getDirection().normalize();
        World world = player.getWorld();
        double radius = 0.3;
        double heightStep = 0.2;
        int points = 360;
        double angleStep = 0.5;
        Vector forward = direction.clone();
        Vector up = this.getPerpendicularVector(forward).normalize();
        Vector right = forward.clone().getCrossProduct(up).normalize();
        ArrayList<LivingEntity> alreadyHit = new ArrayList<LivingEntity>();
        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_RESONATE, 1.0f, 2.0f);
        for (int i = 0; i < points; ++i) {
            double angle = (double)i * angleStep;
            double x = Math.cos(angle) * radius;
            double y = Math.sin(angle) * radius;
            double z = (double)i * heightStep;
            Vector offset = right.clone().multiply(x).add(up.clone().multiply(y)).add(forward.clone().multiply(z));
            Location particleLocation = start.clone().add(offset);
            Color[] blueShades = new Color[]{Color.fromRGB((int)0, (int)0, (int)255), Color.fromRGB((int)0, (int)64, (int)255), Color.fromRGB((int)0, (int)128, (int)255), Color.fromRGB((int)0, (int)191, (int)255), Color.fromRGB((int)30, (int)144, (int)255), Color.fromRGB((int)70, (int)130, (int)180), Color.fromRGB((int)100, (int)149, (int)237), Color.fromRGB((int)135, (int)206, (int)250), Color.fromRGB((int)173, (int)216, (int)230), Color.fromRGB((int)224, (int)255, (int)255)};
            AetheriumItems.particleApi.spawnColoredParticles(particleLocation, blueShades[new Random().nextInt(blueShades.length)], 1.0f, 1, 0.0, 0.0, 0.0);
            if (particleLocation.getNearbyLivingEntities(2.0).isEmpty()) continue;
            for (LivingEntity e : particleLocation.getNearbyLivingEntities(2.0)) {
                if (e.equals((Object)player) || alreadyHit.contains(e)) continue;
                e.damage(8.0, (Entity)player);
                AetheriumItems.particleApi.spawnColoredParticles(particleLocation, Color.AQUA, 1.0f, 100, 2.0, 2.0, 2.0);
                player.getWorld().playSound(particleLocation.clone(), Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 1.0f, 2.0f);
                alreadyHit.add(e);
            }
        }
    }

    private Vector getPerpendicularVector(Vector v) {
        if (v.getX() == 0.0 && v.getZ() == 0.0) {
            return new Vector(1, 0, 0);
        }
        return new Vector(-v.getZ(), 0.0, v.getX());
    }
}

