/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.scrolls.custom;

import java.util.Random;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.pullolo.aetheriumItems.AetheriumItems;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import net.pullolo.aetheriumItems.utils.CooldownApi;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class ShadowstepScroll
extends Scroll {
    public ShadowstepScroll() {
        this.type = "shadowstep";
        this.name = "Shadowstep";
        this.cooldown = 10;
        this.description.add("Teleport behind the nearest enemy");
        this.description.add("in your line of sight and strike.");
    }

    @Override
    public void executeAbility(final Player p) {
        if (CooldownApi.isOnCooldown("shadowstep-scroll", p)) {
            this.onCooldownInfo(p, CooldownApi.getCooldownForPlayerLong("shadowstep-scroll", p));
            return;
        }
        LivingEntity target = this.getTargetInSight(p, 20.0);
        if (target == null) {
            p.sendMessage(Component.text((String)"No valid target in sight!").color(TextColor.color((int)255, (int)0, (int)0)));
            return;
        }
        final Location start = p.getLocation().clone();
        Location behindTarget = target.getLocation().clone().add(target.getLocation().getDirection().normalize().multiply(-1));
        behindTarget.setY(behindTarget.getY() + 0.2);
        Vector facingVector = target.getLocation().toVector().subtract(behindTarget.toVector()).normalize();
        float yaw = (float)Math.toDegrees(Math.atan2(-facingVector.getX(), facingVector.getZ()));
        behindTarget.setYaw(yaw);
        AetheriumItems.particleApi.spawnColoredParticles(p.getLocation(), Color.PURPLE, 0.5f, 10, 0.5, 0.5, 0.05);
        p.getWorld().playSound(p.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.2f);
        p.teleport(behindTarget);
        AetheriumItems.particleApi.spawnColoredParticles(behindTarget, Color.PURPLE, 0.5f, 10, 0.5, 0.5, 0.05);
        p.getWorld().playSound(behindTarget, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        p.getWorld().playSound(behindTarget, Sound.ENTITY_WITHER_SHOOT, 1.0f, 1.6f);
        target.damage(6.0, (Entity)p);
        p.swingMainHand();
        Bukkit.getScheduler().runTask((Plugin)AetheriumItems.aetheriumItemsPlugin, new Runnable(){

            @Override
            public void run() {
                Random r = new Random();
                Vector v = p.getLocation().getDirection().clone().normalize().multiply(-0.5).setY(0.9);
                p.setVelocity(v);
                new BukkitRunnable(){
                    int i = 0;

                    public void run() {
                        ++this.i;
                        if (p.isSneaking()) {
                            p.teleport(start);
                            AetheriumItems.particleApi.spawnColoredParticles(p.getLocation(), Color.PURPLE, 0.5f, 10, 0.5, 0.5, 0.05);
                            p.getWorld().playSound(start, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                            p.getWorld().playSound(start, Sound.ENTITY_WITHER_SHOOT, 1.0f, 1.6f);
                            this.cancel();
                            return;
                        }
                        if (this.i > 80) {
                            this.cancel();
                            return;
                        }
                    }
                }.runTaskTimer((Plugin)AetheriumItems.aetheriumItemsPlugin, 0L, 1L);
            }
        });
        CooldownApi.addCooldown("shadowstep-scroll", p, this.cooldown);
    }

    private LivingEntity getTargetInSight(Player player, double range) {
        RayTraceResult result = player.getWorld().rayTraceEntities(player.getEyeLocation(), player.getEyeLocation().getDirection(), range, entity -> entity instanceof LivingEntity && !entity.equals((Object)player));
        return result != null ? (LivingEntity)result.getHitEntity() : null;
    }
}

