/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.scrolls.custom;

import java.util.Random;
import net.pullolo.aetheriumItems.AetheriumItems;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import net.pullolo.aetheriumItems.utils.CooldownApi;
import net.pullolo.aetheriumItems.utils.Utils;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ShriekScroll
extends Scroll {
    public ShriekScroll() {
        this.type = "shriek";
        this.name = "Shriek Missile";
        this.description.add("Shoot a powerful shriek missile in the");
        this.description.add("direction you are looking at.");
        this.cooldown = 16;
    }

    @Override
    public void executeAbility(Player p) {
        if (CooldownApi.isOnCooldown("shriek-scroll", p)) {
            this.onCooldownInfo(p, CooldownApi.getCooldownForPlayerLong("shriek-scroll", p));
            return;
        }
        this.magicMissile(p);
        CooldownApi.addCooldown("shriek-scroll", p, this.cooldown);
    }

    private void magicMissile(final Player p) {
        p.getWorld().playSound(p.getLocation(), Sound.ENTITY_FIREWORK_ROCKET_LAUNCH, 1.0f, 2.0f);
        final ArmorStand as = (ArmorStand)p.getWorld().spawn(p.getLocation().add(0.0, 1.5, 0.0), ArmorStand.class, en -> {
            en.setVisible(false);
            en.setGravity(false);
            en.setSmall(true);
            en.setMarker(true);
        });
        Location dest = p.getLocation().add(Utils.rotateVector(p.getLocation().getDirection(), 0.0).multiply(10));
        final Vector v = dest.subtract(p.getLocation().clone()).toVector();
        final double s = 1.0;
        final int d = 20;
        final Color[] colors = new Color[]{Color.fromRGB((int)255, (int)59, (int)232), Color.fromRGB((int)0, (int)255, (int)217), Color.fromRGB((int)240, (int)214, (int)255)};
        new BukkitRunnable(){
            final Random r = new Random();
            final int distance = d;
            final double speed = s;
            int i = 1;

            public void run() {
                if (p == null) {
                    as.remove();
                    this.cancel();
                }
                AetheriumItems.particleApi.spawnColoredParticles(as.getLocation(), colors[this.r.nextInt(colors.length)], 1.0f, 3, 0.01, 0.01, 0.01);
                if (this.r.nextBoolean()) {
                    AetheriumItems.particleApi.spawnParticles(as.getLocation(), Particle.GLOW, this.r.nextInt(10) + 1, 0.01, 0.01, 0.01, 0.01);
                }
                as.teleport(as.getLocation().add(v.normalize().multiply(this.speed)));
                for (Entity entity : as.getLocation().getChunk().getEntities()) {
                    if (as.isDead() || entity instanceof ArmorStand || !(as.getLocation().distanceSquared(entity.getLocation()) <= 3.8) || entity.equals((Object)p) || !(entity instanceof LivingEntity)) continue;
                    ((LivingEntity)entity).damage(18.0, (Entity)p);
                    ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 100, 0));
                    ShriekScroll.this.spellExplode(p, as.getLocation().clone());
                    as.remove();
                    this.cancel();
                }
                boolean l = as.getLocation().clone().getBlock().isLiquid();
                if (!(as.getLocation().clone().getBlock().isPassable() && !l || as.isDead())) {
                    ShriekScroll.this.spellExplode(p, as.getLocation().clone());
                    as.remove();
                    this.cancel();
                }
                if (this.i > this.distance && !as.isDead()) {
                    ShriekScroll.this.spellExplode(p, as.getLocation().clone());
                    as.remove();
                    this.cancel();
                }
                ++this.i;
            }
        }.runTaskTimer((Plugin)AetheriumItems.aetheriumItemsPlugin, 0L, 1L);
    }

    private void spellExplode(Player p, Location l) {
        AetheriumItems.particleApi.spawnParticles(l, Particle.GUST, 1, 0.0, 0.0, 0.0, 1.0);
        AetheriumItems.particleApi.spawnParticles(l, Particle.GLOW, 100, 1.0, 1.0, 1.0, 10.0);
        AetheriumItems.particleApi.spawnParticles(l, Particle.FIREWORK, 100, 0.1, 0.1, 0.1, 0.4);
        l.getWorld().playSound(l, Sound.ENTITY_FIREWORK_ROCKET_BLAST, 1.0f, 0.6f);
        l.getWorld().playSound(l, Sound.ENTITY_FIREWORK_ROCKET_LARGE_BLAST, 1.0f, 0.9f);
        l.getWorld().playSound(l, Sound.ENTITY_FIREWORK_ROCKET_TWINKLE_FAR, 1.0f, 1.0f);
        l.getWorld().playSound(l, Sound.ENTITY_WARDEN_SONIC_BOOM, 1.0f, 2.0f);
        for (Entity e : l.getWorld().getNearbyEntities(l, 2.0, 2.0, 2.0)) {
            if (!(e instanceof LivingEntity)) continue;
            ((LivingEntity)e).damage(16.0, (Entity)p);
        }
    }
}

