/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.scrolls.custom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import net.pullolo.aetheriumItems.items.Item;
import net.pullolo.aetheriumItems.scrolls.PassiveAbility;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import net.pullolo.aetheriumItems.utils.CooldownApi;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class TreecapitatorScroll
extends Scroll
implements PassiveAbility,
Listener {
    public TreecapitatorScroll() {
        this.type = "treecapitator";
        this.name = "Treecapitator";
        this.onlyPassive = true;
        this.cooldown = 10;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Player p = event.getPlayer();
        ItemStack heldItem = p.getInventory().getItemInMainHand();
        if (!heldItem.hasItemMeta()) {
            return;
        }
        Item item = new Item(heldItem);
        if (!(item.isCustomItem() && item.hasScroll() && item.getScroll() instanceof TreecapitatorScroll)) {
            return;
        }
        if (CooldownApi.isOnCooldown("treecapitator-scroll", p)) {
            this.onCooldownInfo(p, CooldownApi.getCooldownForPlayerLong("treecapitator-scroll", p));
            return;
        }
        Material logType = block.getType();
        if (!logType.name().endsWith("_LOG") && !logType.name().endsWith("_STEM")) {
            return;
        }
        HashSet<Block> visited = new HashSet<Block>();
        LinkedList<Block> queue = new LinkedList<Block>();
        queue.add(block);
        int maxBlocks = 128;
        while (!queue.isEmpty() && visited.size() < maxBlocks) {
            Block current = (Block)queue.poll();
            if (visited.contains(current) || current.getType() != logType) continue;
            visited.add(current);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        Block neighbor = current.getRelative(dx, dy, dz);
                        if (visited.contains(neighbor) || neighbor.getType() != logType) continue;
                        queue.add(neighbor);
                    }
                }
            }
        }
        visited.remove(block);
        for (Block b : visited) {
            b.breakNaturally(p.getInventory().getItemInMainHand());
        }
        CooldownApi.addCooldown("treecapitator-scroll", p, this.cooldown);
    }

    @Override
    public void onApply(Player player) {
    }

    @Override
    public void onRemove(Player player) {
    }

    @Override
    public ArrayList<String> getPassiveDescription() {
        ArrayList<String> description = new ArrayList<String>();
        description.add("Allows you to break a large amount");
        description.add("of logs in a single hit.");
        return description;
    }

    @Override
    public void executeAbility(Player p) {
    }
}

