/*
 * Decompiled with CFR 0.152.
 */
package net.pullolo.aetheriumItems.scrolls.custom;

import net.pullolo.aetheriumItems.AetheriumItems;
import net.pullolo.aetheriumItems.scrolls.Scroll;
import net.pullolo.aetheriumItems.utils.CooldownApi;
import net.pullolo.aetheriumItems.utils.Utils;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class WeatherScroll
extends Scroll {
    public WeatherScroll() {
        this.type = "weather";
        this.name = "Weather Control";
        this.description.add("Switch weather between rainy and sunny.");
        this.cooldown = 600;
    }

    @Override
    public void executeAbility(final Player p) {
        if (CooldownApi.isOnCooldown("weather-scroll", p)) {
            this.onCooldownInfo(p, CooldownApi.getCooldownForPlayerLong("weather-scroll", p));
            return;
        }
        p.getWorld().playSound(p.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_RESONATE, 1.0f, 0.8f);
        new BukkitRunnable(this){
            int i = 0;

            public void run() {
                if (this.i > 60) {
                    this.cancel();
                    return;
                }
                Location l = p.getLocation().clone().add(0.0, 2.0, 0.0).subtract(0.0, (double)this.i / 50.0, 0.0).add(Utils.rotateVector(new Vector(1, 0, 0), this.i * 20));
                AetheriumItems.particleApi.spawnColoredParticles(l, Color.AQUA, 1.0f, 2, 0.1, 0.1, 0.1);
                ++this.i;
            }
        }.runTaskTimer((Plugin)AetheriumItems.aetheriumItemsPlugin, 0L, 2L);
        p.getWorld().setStorm(!p.getWorld().hasStorm());
        CooldownApi.addCooldown("weather-scroll", p, this.cooldown);
    }
}

