/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.basics;

import java.util.HashMap;
import net.mcreator.reignmod.configuration.ReignCommonConfiguration;
import net.mcreator.reignmod.configuration.ReignMarketConfiguration;
import net.mcreator.reignmod.market.MarketItem;

public class ConfigLoader {
    private static final HashMap<String, MarketItem> marketItems = new HashMap();
    private static boolean DISABLE_VANILLA_VILLAGERS;
    private static boolean DISABLE_MARKET_TAX;
    private static boolean DISABLE_HOUSE_FEEDING;
    private static boolean DISABLE_DAILY_PAYOUTS;
    private static boolean DISABLE_CAPITAL_FEEDING;
    private static boolean DISABLE_LICENSE_LVL_LOSS;
    private static double HOURLY_MEAL_PERIOD;

    public static HashMap<String, MarketItem> getMarketItems() {
        return marketItems;
    }

    public static boolean areVillagersDisabled() {
        return DISABLE_VANILLA_VILLAGERS;
    }

    public static boolean areMarketTaxesDisabled() {
        return DISABLE_MARKET_TAX;
    }

    public static boolean isHouseFeedingDisabled() {
        return DISABLE_HOUSE_FEEDING;
    }

    public static boolean areDailyPayoutsDisabled() {
        return DISABLE_DAILY_PAYOUTS;
    }

    public static boolean isCapitalFeedingDisabled() {
        return DISABLE_CAPITAL_FEEDING;
    }

    public static boolean isLicenseLvlLossDisable() {
        return DISABLE_LICENSE_LVL_LOSS;
    }

    public static double getHourlyMealPeriod() {
        return HOURLY_MEAL_PERIOD;
    }

    private static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    private static double computePrice(double basePrice, double multiplier) {
        double validMultiplier = ConfigLoader.clamp(multiplier, 0.5, 2.0);
        double validBasePrice = ConfigLoader.clamp(basePrice, 4.0, 4096.0);
        double computedPrice = validBasePrice * validMultiplier;
        return ConfigLoader.clamp(computedPrice, 4.0, 8192.0);
    }

    public static void initialize() {
        ConfigLoader.loadMarketPrices();
        ConfigLoader.loadCommonConfig();
    }

    private static void loadMarketPrices() {
        marketItems.clear();
        double toolsMaxAmount = ConfigLoader.clamp((Double)ReignMarketConfiguration.TOOLS_MAX_AMOUNT.get(), 1.0, 1023.0);
        double goodsMaxAmount = ConfigLoader.clamp((Double)ReignMarketConfiguration.GOODS_MAX_AMOUNT.get(), 1.0, 1023.0);
        marketItems.put("minecraft:oak_log", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.OAK_LOG.get(), (Double)ReignMarketConfiguration.LOGS_MULTIPLIER.get()), goodsMaxAmount, 8.0));
        marketItems.put("minecraft:spruce_log", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.SPRUCE_LOG.get(), (Double)ReignMarketConfiguration.LOGS_MULTIPLIER.get()), goodsMaxAmount, 8.0));
        marketItems.put("minecraft:birch_log", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.BIRCH_LOG.get(), (Double)ReignMarketConfiguration.LOGS_MULTIPLIER.get()), goodsMaxAmount, 8.0));
        marketItems.put("minecraft:acacia_log", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.ACACIA_LOG.get(), (Double)ReignMarketConfiguration.LOGS_MULTIPLIER.get()), goodsMaxAmount, 8.0));
        marketItems.put("minecraft:dark_oak_log", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.DARK_OAK_LOG.get(), (Double)ReignMarketConfiguration.LOGS_MULTIPLIER.get()), goodsMaxAmount, 8.0));
        marketItems.put("minecraft:jungle_log", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.JUNGLE_LOG.get(), (Double)ReignMarketConfiguration.LOGS_MULTIPLIER.get()), goodsMaxAmount, 8.0));
        marketItems.put("minecraft:mangrove_log", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.MANGROVE_LOG.get(), (Double)ReignMarketConfiguration.LOGS_MULTIPLIER.get()), goodsMaxAmount, 8.0));
        marketItems.put("minecraft:cherry_log", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.CHERRY_LOG.get(), (Double)ReignMarketConfiguration.LOGS_MULTIPLIER.get()), goodsMaxAmount, 8.0));
        marketItems.put("minecraft:coal", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.COAL.get(), (Double)ReignMarketConfiguration.FUEL_MULTIPLIER.get()), goodsMaxAmount, 4.0));
        marketItems.put("minecraft:charcoal", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.CHARCOAL.get(), (Double)ReignMarketConfiguration.FUEL_MULTIPLIER.get()), goodsMaxAmount, 4.0));
        marketItems.put("minecraft:raw_copper", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.RAW_COPPER.get(), (Double)ReignMarketConfiguration.ORES_MULTIPLIER.get()), goodsMaxAmount, 4.0));
        marketItems.put("minecraft:raw_iron", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.RAW_IRON.get(), (Double)ReignMarketConfiguration.ORES_MULTIPLIER.get()), goodsMaxAmount, 2.0));
        marketItems.put("minecraft:raw_gold", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.RAW_GOLD.get(), (Double)ReignMarketConfiguration.ORES_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:diamond", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.DIAMOND.get(), (Double)ReignMarketConfiguration.ORES_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:lapis_lazuli", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.LAPIS_LAZULI.get(), (Double)ReignMarketConfiguration.ORES_MULTIPLIER.get()), goodsMaxAmount, 4.0));
        marketItems.put("minecraft:redstone", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.REDSTONE.get(), (Double)ReignMarketConfiguration.ORES_MULTIPLIER.get()), goodsMaxAmount, 8.0));
        marketItems.put("minecraft:emerald", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.EMERALD.get(), (Double)ReignMarketConfiguration.ORES_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:netherite_scrap", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.NETHERITE_SCRAP.get(), (Double)ReignMarketConfiguration.ORES_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:copper_ingot", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.COPPER_INGOT.get(), (Double)ReignMarketConfiguration.INGOTS_MULTIPLIER.get()), goodsMaxAmount, 2.0));
        marketItems.put("minecraft:iron_ingot", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.IRON_INGOT.get(), (Double)ReignMarketConfiguration.INGOTS_MULTIPLIER.get()), goodsMaxAmount, 2.0));
        marketItems.put("minecraft:gold_ingot", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.GOLD_INGOT.get(), (Double)ReignMarketConfiguration.INGOTS_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:netherite_ingot", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.NETHERITE_INGOT.get(), (Double)ReignMarketConfiguration.INGOTS_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:iron_sword", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.IRON_SWORD.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:iron_pickaxe", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.IRON_PICKAXE.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:iron_axe", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.IRON_AXE.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:iron_shovel", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.IRON_SHOVEL.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:iron_helmet", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.IRON_HELMET.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:iron_chestplate", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.IRON_CHESTPLATE.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:iron_leggings", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.IRON_LEGGINGS.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:iron_boots", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.IRON_BOOTS.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:diamond_sword", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.DIAMOND_SWORD.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:diamond_pickaxe", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.DIAMOND_PICKAXE.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:diamond_axe", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.DIAMOND_AXE.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:diamond_shovel", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.DIAMOND_SHOVEL.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:diamond_helmet", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.DIAMOND_HELMET.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:diamond_chestplate", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.DIAMOND_CHESTPLATE.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:diamond_leggings", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.DIAMOND_LEGGINGS.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:diamond_boots", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.DIAMOND_BOOTS.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:shield", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.SHIELD.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:shears", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.SHEARS.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:bow", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.BOW.get(), (Double)ReignMarketConfiguration.TOOLS_MULTIPLIER.get()), toolsMaxAmount, 1.0));
        marketItems.put("minecraft:bread", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.BREAD.get(), (Double)ReignMarketConfiguration.FOOD_MULTIPLIER.get()), goodsMaxAmount, 4.0));
        marketItems.put("minecraft:baked_potato", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.BAKED_POTATO.get(), (Double)ReignMarketConfiguration.FOOD_MULTIPLIER.get()), goodsMaxAmount, 4.0));
        marketItems.put("minecraft:pumpkin_pie", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.PUMPKIN_PIE.get(), (Double)ReignMarketConfiguration.FOOD_MULTIPLIER.get()), goodsMaxAmount, 2.0));
        marketItems.put("minecraft:carrot", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.CARROT.get(), (Double)ReignMarketConfiguration.FOOD_MULTIPLIER.get()), goodsMaxAmount, 6.0));
        marketItems.put("minecraft:cooked_beef", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.COOKED_BEEF.get(), (Double)ReignMarketConfiguration.FOOD_MULTIPLIER.get()), goodsMaxAmount, 2.0));
        marketItems.put("minecraft:cooked_porkchop", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.COOKED_PORKCHOP.get(), (Double)ReignMarketConfiguration.FOOD_MULTIPLIER.get()), goodsMaxAmount, 2.0));
        marketItems.put("minecraft:cooked_chicken", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.COOKED_CHICKEN.get(), (Double)ReignMarketConfiguration.FOOD_MULTIPLIER.get()), goodsMaxAmount, 3.0));
        marketItems.put("minecraft:cooked_cod", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.COOKED_COD.get(), (Double)ReignMarketConfiguration.FOOD_MULTIPLIER.get()), goodsMaxAmount, 4.0));
        marketItems.put("minecraft:hay_block", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.HAY_BLOCK.get(), (Double)ReignMarketConfiguration.FOOD_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:honey_bottle", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.HONEY_BOTTLE.get(), (Double)ReignMarketConfiguration.FOOD_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:cobblestone", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.COBBLESTONE.get(), (Double)ReignMarketConfiguration.BLOCKS_MULTIPLIER.get()), goodsMaxAmount, 16.0));
        marketItems.put("minecraft:sand", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.SAND.get(), (Double)ReignMarketConfiguration.BLOCKS_MULTIPLIER.get()), goodsMaxAmount, 16.0));
        marketItems.put("minecraft:white_wool", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.WHITE_WOOL.get(), (Double)ReignMarketConfiguration.BLOCKS_MULTIPLIER.get()), goodsMaxAmount, 8.0));
        marketItems.put("minecraft:clay", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.CLAY.get(), (Double)ReignMarketConfiguration.BLOCKS_MULTIPLIER.get()), goodsMaxAmount, 2.0));
        marketItems.put("minecraft:glass_bottle", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.GLASS_BOTTLE.get(), (Double)ReignMarketConfiguration.OTHER_MULTIPLIER.get()), goodsMaxAmount, 8.0));
        marketItems.put("minecraft:arrow", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.ARROW.get(), (Double)ReignMarketConfiguration.OTHER_MULTIPLIER.get()), goodsMaxAmount, 4.0));
        marketItems.put("minecraft:experience_bottle", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.EXPERIENCE_BOTTLE.get(), 1.0), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:gunpowder", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.GUNPOWDER.get(), (Double)ReignMarketConfiguration.OTHER_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:bone", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.BONE.get(), (Double)ReignMarketConfiguration.OTHER_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:string", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.STRING.get(), (Double)ReignMarketConfiguration.OTHER_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:slime_ball", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.SLIME_BALL.get(), (Double)ReignMarketConfiguration.OTHER_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:paper", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.PAPER.get(), (Double)ReignMarketConfiguration.OTHER_MULTIPLIER.get()), goodsMaxAmount, 3.0));
        marketItems.put("minecraft:feather", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.FEATHER.get(), (Double)ReignMarketConfiguration.OTHER_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:glowstone_dust", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.GLOWSTONE_DUST.get(), (Double)ReignMarketConfiguration.OTHER_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:ender_pearl", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.ENDER_PEARL.get(), (Double)ReignMarketConfiguration.OTHER_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:leather", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.ENDER_PEARL.get(), (Double)ReignMarketConfiguration.OTHER_MULTIPLIER.get()), goodsMaxAmount, 1.0));
        marketItems.put("minecraft:blaze_rod", new MarketItem(ConfigLoader.computePrice((Double)ReignMarketConfiguration.BLAZE_ROD.get(), (Double)ReignMarketConfiguration.OTHER_MULTIPLIER.get()), goodsMaxAmount, 1.0));
    }

    private static void loadCommonConfig() {
        DISABLE_VANILLA_VILLAGERS = (Boolean)ReignCommonConfiguration.DISABLE_VANILLA_VILLAGERS.get();
        DISABLE_MARKET_TAX = (Boolean)ReignCommonConfiguration.DISABLE_MARKET_TAX.get();
        DISABLE_HOUSE_FEEDING = (Boolean)ReignCommonConfiguration.DISABLE_HOUSE_FEEDING.get();
        DISABLE_DAILY_PAYOUTS = (Boolean)ReignCommonConfiguration.DISABLE_DAILY_PAYOUTS.get();
        DISABLE_CAPITAL_FEEDING = (Boolean)ReignCommonConfiguration.DISABLE_CAPITAL_FEEDING.get();
        HOURLY_MEAL_PERIOD = (Double)ReignCommonConfiguration.HOURLY_MEAL_PERIOD.get();
    }
}

