/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.basics;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import net.mcreator.reignmod.basics.ReignChatEventUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class ReignChatEvent {
    public static Component onClientChat(ChatType type, Component message, UUID senderUUID) {
        String chatInRaw = message.getString();
        if (!chatInRaw.startsWith("<") || !chatInRaw.contains("> ")) {
            return message;
        }
        String[] cirspl = chatInRaw.split("> ");
        if (cirspl.length < 2) {
            return message;
        }
        String timestamp = new SimpleDateFormat("HH:mm").format(new Date());
        String user = cirspl[0].substring(1);
        String messageString = chatInRaw.replace(cirspl[0] + "> ", "");
        return ReignChatEvent.getMutableComponent(timestamp, user, messageString);
    }

    @NotNull
    private static MutableComponent getMutableComponent(String timestamp, String user, String messageString) {
        MutableComponent output = Component.m_237113_((String)"");
        String raw_outputstring = "%timestamp% | %username%: %chatmessage%";
        for (String word : raw_outputstring.split("%")) {
            ChatFormatting colour = ReignChatEventUtil.getColour(word);
            String toappend = word;
            if (word.equalsIgnoreCase("timestamp")) {
                toappend = timestamp;
            } else if (word.equalsIgnoreCase("username")) {
                toappend = user;
            } else if (word.equalsIgnoreCase("chatmessage")) {
                toappend = messageString;
            }
            MutableComponent wordcomponent = Component.m_237113_((String)toappend);
            wordcomponent.m_130940_(colour);
            output.m_7220_((Component)wordcomponent);
        }
        return output;
    }
}

