/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.basics;

public class ReignCommon {
    public static int safeParseInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int calculateRectangleArea(String widthStr, String heightStr, int defaultValue) {
        int width = ReignCommon.safeParseInt(widthStr, -1);
        int height = ReignCommon.safeParseInt(heightStr, -1);
        if (width < 0 || height < 0) {
            return defaultValue;
        }
        return width * height;
    }

    public static boolean isRectangleCorrect(String widthStr, String heightStr, double maxArea) {
        int width = ReignCommon.safeParseInt(widthStr, -1);
        int height = ReignCommon.safeParseInt(heightStr, -1);
        if (width < 3 || height < 3) {
            return false;
        }
        if (width % 2 == 0 || height % 2 == 0) {
            return false;
        }
        int area = width * height;
        if ((double)area > maxArea) {
            return false;
        }
        return Math.max(width, height) <= 3 * Math.min(width, height);
    }
}

