/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.claim.capital;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.mcreator.reignmod.claim.capital.CapitalClaimSavedData;
import net.mcreator.reignmod.claim.capital.ClaimOwner;
import net.mcreator.reignmod.claim.capital.TerritoryClaim;
import net.mcreator.reignmod.networking.ReignNetworking;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Player;

public class CapitalClaimManager {
    private static int capitalCenterX = 0;
    private static int capitalCenterZ = 0;

    private static int offsetX() {
        return capitalCenterX - 256;
    }

    private static int offsetZ() {
        return capitalCenterZ - 256;
    }

    public static int getCapitalCenterX() {
        return capitalCenterX;
    }

    public static int getCapitalCenterZ() {
        return capitalCenterZ;
    }

    public static void setCapitalCenter(int x, int z) {
        CapitalClaimSavedData.getInstance().setCapitalCenter(x, z);
        capitalCenterX = x;
        capitalCenterZ = z;
    }

    public static void setCapitalCenter(ServerPlayer sp) {
        CapitalClaimManager.setCapitalCenter(sp.m_146903_(), sp.m_146907_());
    }

    public static int toLocalX(int worldX) {
        return worldX - CapitalClaimManager.offsetX();
    }

    public static int toLocalZ(int worldZ) {
        return worldZ - CapitalClaimManager.offsetZ();
    }

    public static boolean addClaim(ServerPlayer serverPlayer, String owners, double centerX, double centerY, double centerZ, String width, String height) {
        TerritoryClaim claim;
        int intHeight;
        int intWidth;
        if (!CapitalClaimSavedData.getInstance().isCapitalClaimsEnabled()) {
            serverPlayer.m_5661_((Component)Component.m_237115_((String)"capitalclaim.system.disabled"), true);
            return false;
        }
        List<String> ownerNames = CapitalClaimManager.parseOwnerNames(owners);
        if (ownerNames.isEmpty()) {
            serverPlayer.m_5661_((Component)Component.m_237110_((String)"capitalclaim.add.fail", (Object[])new Object[]{"Empty owners list"}), true);
            return false;
        }
        MinecraftServer server = serverPlayer.m_20194_();
        UUID mainOwnerUUID = CapitalClaimManager.getOfflinePlayerUUID(server, ownerNames.get(0));
        if (mainOwnerUUID == null) {
            serverPlayer.m_5661_((Component)Component.m_237110_((String)"capitalclaim.add.fail", (Object[])new Object[]{"Main owner not found: " + ownerNames.get(0)}), true);
            return false;
        }
        ClaimOwner claimOwner = new ClaimOwner(mainOwnerUUID);
        for (int i = 1; i < ownerNames.size(); ++i) {
            String name = ownerNames.get(i);
            UUID uuid = CapitalClaimManager.getOfflinePlayerUUID(server, name);
            if (uuid != null) {
                claimOwner.addCoOwner(uuid);
                continue;
            }
            serverPlayer.m_5661_((Component)Component.m_237110_((String)"capitalclaim.add.warn", (Object[])new Object[]{"Co-owner not found: " + name}), true);
        }
        int localCenterX = CapitalClaimManager.toLocalX((int)centerX);
        int localCenterZ = CapitalClaimManager.toLocalZ((int)centerZ);
        int intCenterY = (int)centerY;
        try {
            intWidth = Integer.parseInt(width);
            intHeight = Integer.parseInt(height);
        }
        catch (NumberFormatException e) {
            serverPlayer.m_5661_((Component)Component.m_237110_((String)"capitalclaim.add.fail", (Object[])new Object[]{"Invalid width/height format."}), true);
            return false;
        }
        try {
            claim = new TerritoryClaim(localCenterX, intCenterY, localCenterZ, intWidth, intHeight);
        }
        catch (IllegalArgumentException ex) {
            serverPlayer.m_5661_((Component)Component.m_237110_((String)"capitalclaim.add.fail", (Object[])new Object[]{ex.getMessage()}), true);
            return false;
        }
        boolean success = CapitalClaimSavedData.getInstance().addClaim(claimOwner, claim);
        if (success) {
            StringBuilder ownersList = new StringBuilder();
            ownersList.append(ownerNames.get(0));
            for (int i = 1; i < ownerNames.size(); ++i) {
                ownersList.append(", ").append(ownerNames.get(i));
            }
            serverPlayer.m_5661_((Component)Component.m_237110_((String)"capitalclaim.add.success", (Object[])new Object[]{(int)centerX, intCenterY, (int)centerZ, ownersList.toString()}), true);
            ReignNetworking.resetLastKnownBlockForAllPlayers();
            return true;
        }
        serverPlayer.m_5661_((Component)Component.m_237110_((String)"capitalclaim.add.fail", (Object[])new Object[]{"Area is occupied or invalid."}), true);
        return false;
    }

    public static boolean removeClaim(Player player, double centerX, double centerZ) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!CapitalClaimSavedData.getInstance().isCapitalClaimsEnabled()) {
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"capitalclaim.system.disabled"), true);
                return false;
            }
            int localCenterX = CapitalClaimManager.toLocalX((int)centerX);
            int localCenterZ = CapitalClaimManager.toLocalZ((int)centerZ);
            if (CapitalClaimSavedData.getInstance().removeClaim(localCenterX, localCenterZ)) {
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"capitalclaim.remove.success"), true);
                ReignNetworking.resetLastKnownBlockForAllPlayers();
                return true;
            }
            serverPlayer.m_5661_((Component)Component.m_237115_((String)"capitalclaim.remove.fail"), true);
        }
        return false;
    }

    public static boolean removeClaim(double centerX, double centerZ) {
        if (CapitalClaimSavedData.getInstance().isCapitalClaimsEnabled()) {
            int localCenterX = CapitalClaimManager.toLocalX((int)centerX);
            int localCenterZ = CapitalClaimManager.toLocalZ((int)centerZ);
            return CapitalClaimSavedData.getInstance().removeClaim(localCenterX, localCenterZ);
        }
        return false;
    }

    public static void enable() {
        CapitalClaimSavedData.getInstance().enable();
    }

    public static void disable() {
        CapitalClaimSavedData.getInstance().disable();
    }

    private static List<String> parseOwnerNames(String owners) {
        String[] tokens;
        ArrayList<String> names = new ArrayList<String>();
        if (owners == null || owners.trim().isEmpty()) {
            return names;
        }
        for (String token : tokens = owners.split("[,\\s]+")) {
            if (token.trim().isEmpty()) continue;
            names.add(token.trim());
        }
        return names;
    }

    public static UUID getOfflinePlayerUUID(MinecraftServer server, String playerName) {
        Optional profile;
        GameProfileCache cache = server.m_129927_();
        if (cache != null && (profile = cache.m_10996_(playerName)).isPresent()) {
            return ((GameProfile)profile.get()).getId();
        }
        return null;
    }
}

