/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.claim.capital;

import java.util.HashMap;
import java.util.Map;
import net.mcreator.reignmod.basics.ReignSavedData;
import net.mcreator.reignmod.claim.capital.CapitalClaimManager;
import net.mcreator.reignmod.claim.capital.ClaimOwner;
import net.mcreator.reignmod.claim.capital.TerritoryClaim;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;

public class CapitalClaimSavedData
extends ReignSavedData {
    public static final int CAPITAL_SIZE = 511;
    private static final int PRIME = 31;
    private static CapitalClaimSavedData instance;
    private static String chunkClaimId;
    private int capitalHeartX = 0;
    private int capitalHeartZ = 0;
    private final HashMap<ClaimOwner, HashMap<Long, TerritoryClaim>> claimsMap = new HashMap();
    private final ClaimOwner[][] ownerGrid = new ClaimOwner[511][511];
    private boolean capitalClaimsEnabled = false;

    public CapitalClaimSavedData() {
    }

    public CapitalClaimSavedData(CompoundTag compoundTag) {
        this.capitalHeartX = compoundTag.m_128451_("capital_center_x");
        this.capitalHeartZ = compoundTag.m_128451_("capital_center_z");
        ListTag claimList = compoundTag.m_128437_("claims", 10);
        for (int i = 0; i < claimList.size(); ++i) {
            CompoundTag entryTag = claimList.m_128728_(i);
            ClaimOwner owner = ClaimOwner.deserializeNBT(entryTag.m_128469_("owner"));
            TerritoryClaim claim = TerritoryClaim.deserializeNBT(entryTag.m_128469_("claim"));
            this.claimsMap.computeIfAbsent(owner, k -> new HashMap()).put(CapitalClaimSavedData.calculateHash(claim.getCenterX(), claim.getCenterZ()), claim);
            this.fillOwnerGrid(owner, claim);
        }
        this.capitalClaimsEnabled = compoundTag.m_128471_("capital_claims_enabled");
        String loadedClaim = compoundTag.m_128461_("chunk_claim_id");
        chunkClaimId = loadedClaim.isEmpty() ? null : loadedClaim;
    }

    public static void initialize(ServerLevel serverLevel) {
        if (instance == null) {
            instance = (CapitalClaimSavedData)serverLevel.m_8895_().m_164861_(CapitalClaimSavedData::new, CapitalClaimSavedData::new, "capital_claims_data");
            CapitalClaimManager.setCapitalCenter(CapitalClaimSavedData.instance.capitalHeartX, CapitalClaimSavedData.instance.capitalHeartZ);
            CapitalClaimSavedData.instance.serverLevelInstance = serverLevel;
        }
    }

    public static CapitalClaimSavedData getInstance() {
        if (instance == null) {
            throw new IllegalStateException("CapitalClaimsData is not initialized. Call initialize(ServerLevel) first.");
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    public static long calculateHash(int x, int z) {
        return (long)x * 31L ^ (long)z * 31L;
    }

    public void enable() {
        this.capitalClaimsEnabled = true;
        this.m_77762_();
    }

    public void disable() {
        this.capitalClaimsEnabled = false;
        this.m_77762_();
    }

    public boolean isCapitalClaimsEnabled() {
        return this.capitalClaimsEnabled;
    }

    public static String getChunkClaimId() {
        return chunkClaimId;
    }

    public static void setChunkClaimId(String chunkClaimId) {
        CapitalClaimSavedData.chunkClaimId = chunkClaimId;
    }

    public boolean addClaim(ClaimOwner owner, TerritoryClaim claim) {
        if (!this.capitalClaimsEnabled) {
            return false;
        }
        if (!this.isClaimValid(claim)) {
            return false;
        }
        long hash = CapitalClaimSavedData.calculateHash(claim.getCenterX(), claim.getCenterZ());
        this.claimsMap.computeIfAbsent(owner, k -> new HashMap()).put(hash, claim);
        this.fillOwnerGrid(owner, claim);
        this.m_77762_();
        return true;
    }

    public boolean removeClaim(int centerX, int centerZ) {
        TerritoryClaim claim;
        if (!this.capitalClaimsEnabled) {
            return false;
        }
        ClaimOwner owner = this.getOwnerAt(centerX, centerZ);
        if (owner == null) {
            return false;
        }
        long hash = CapitalClaimSavedData.calculateHash(centerX, centerZ);
        Map ownerClaims = this.claimsMap.get(owner);
        if (ownerClaims != null && (claim = (TerritoryClaim)ownerClaims.remove(hash)) != null) {
            this.clearOwnerGrid(claim);
            this.m_77762_();
            return true;
        }
        return false;
    }

    public ClaimOwner getOwnerAt(int x, int z) {
        if (x < 0 || x >= 511 || z < 0 || z >= 511) {
            return null;
        }
        return this.ownerGrid[x][z];
    }

    private boolean isClaimValid(TerritoryClaim newClaim) {
        if (newClaim.getStartX() < 0 || newClaim.getEndX() > 511 || newClaim.getStartZ() < 0 || newClaim.getEndZ() > 511) {
            return false;
        }
        for (int x = newClaim.getStartX(); x < newClaim.getEndX(); ++x) {
            for (int z = newClaim.getStartZ(); z < newClaim.getEndZ(); ++z) {
                if (this.ownerGrid[x][z] == null) continue;
                return false;
            }
        }
        return true;
    }

    private void fillOwnerGrid(ClaimOwner owner, TerritoryClaim claim) {
        for (int x = claim.getStartX(); x < claim.getEndX(); ++x) {
            for (int z = claim.getStartZ(); z < claim.getEndZ(); ++z) {
                this.ownerGrid[x][z] = owner;
            }
        }
    }

    private void clearOwnerGrid(TerritoryClaim claim) {
        for (int x = claim.getStartX(); x < claim.getEndX(); ++x) {
            for (int z = claim.getStartZ(); z < claim.getEndZ(); ++z) {
                this.ownerGrid[x][z] = null;
            }
        }
    }

    public int getCapitalCenterX() {
        return this.capitalHeartX;
    }

    public int getCapitalCenterZ() {
        return this.capitalHeartZ;
    }

    public void setCapitalCenter(int x, int z) {
        this.capitalHeartX = x;
        this.capitalHeartZ = z;
        this.m_77762_();
    }

    @Override
    protected String getDataKey() {
        return "capital_claims_data";
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compoundTag) {
        compoundTag.m_128405_("capital_center_x", this.capitalHeartX);
        compoundTag.m_128405_("capital_center_z", this.capitalHeartZ);
        ListTag claimList = new ListTag();
        for (Map.Entry<ClaimOwner, HashMap<Long, TerritoryClaim>> ownerEntry : this.claimsMap.entrySet()) {
            for (Map.Entry<Long, TerritoryClaim> claimEntry : ownerEntry.getValue().entrySet()) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.m_128365_("owner", (Tag)ownerEntry.getKey().serializeNBT());
                entryTag.m_128365_("claim", (Tag)claimEntry.getValue().serializeNBT());
                claimList.add((Object)entryTag);
            }
        }
        compoundTag.m_128365_("claims", (Tag)claimList);
        compoundTag.m_128379_("capital_claims_enabled", this.capitalClaimsEnabled);
        compoundTag.m_128359_("chunk_claim_id", chunkClaimId == null ? "" : chunkClaimId);
        return compoundTag;
    }

    static {
        chunkClaimId = null;
    }
}

