/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.claim.capital;

import net.minecraft.nbt.CompoundTag;

public class TerritoryClaim {
    private final int startX;
    private final int startZ;
    private final int endX;
    private final int endZ;
    private final int centerX;
    private final int centerZ;
    private final int centerY;

    public TerritoryClaim(int centerX, int centerY, int centerZ, int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height must be positive!");
        }
        if (width % 2 == 0 || height % 2 == 0) {
            throw new IllegalArgumentException("Width and height must be odd numbers!");
        }
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.startX = centerX - width / 2;
        this.startZ = centerZ - height / 2;
        this.endX = this.startX + width;
        this.endZ = this.startZ + height;
        this.centerY = centerY;
    }

    public static TerritoryClaim deserializeNBT(CompoundTag tag) {
        int startX = tag.m_128451_("startX");
        int startZ = tag.m_128451_("startZ");
        int endX = tag.m_128451_("endX");
        int endZ = tag.m_128451_("endZ");
        int centerX = tag.m_128451_("centerX");
        int centerZ = tag.m_128451_("centerZ");
        int centerY = tag.m_128451_("centerY");
        int width = endX - startX;
        int height = endZ - startZ;
        return new TerritoryClaim(centerX, centerY, centerZ, width, height);
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartZ() {
        return this.startZ;
    }

    public int getEndX() {
        return this.endX;
    }

    public int getEndZ() {
        return this.endZ;
    }

    public int getCenterX() {
        return this.centerX;
    }

    public int getCenterZ() {
        return this.centerZ;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public boolean contains(int x, int z) {
        return x >= this.startX && x < this.endX && z >= this.startZ && z < this.endZ;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TerritoryClaim)) {
            return false;
        }
        TerritoryClaim other = (TerritoryClaim)obj;
        return this.centerX == other.centerX && this.centerZ == other.centerZ && this.centerY == other.centerY;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("startX", this.startX);
        tag.m_128405_("startZ", this.startZ);
        tag.m_128405_("endX", this.endX);
        tag.m_128405_("endZ", this.endZ);
        tag.m_128405_("centerX", this.centerX);
        tag.m_128405_("centerZ", this.centerZ);
        tag.m_128405_("centerY", this.centerY);
        return tag;
    }
}

