/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.claim.chunk;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mcreator.reignmod.claim.chunk.ClaimData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class ChunkClaimSavedData
extends SavedData {
    private static ChunkClaimSavedData instance;
    private static ServerLevel serverLevelInstance;
    private final Map<Long, String> chunkToClaimId = new HashMap<Long, String>();
    private final Map<String, ClaimData> claims = new HashMap<String, ClaimData>();

    private ChunkClaimSavedData() {
    }

    private ChunkClaimSavedData(CompoundTag nbt) {
        this.load(nbt);
    }

    public static void initialize(ServerLevel serverLevel) {
        if (instance == null) {
            instance = (ChunkClaimSavedData)serverLevel.m_8895_().m_164861_(ChunkClaimSavedData::new, ChunkClaimSavedData::new, "chunk_data");
            serverLevelInstance = serverLevel;
        }
    }

    public static ChunkClaimSavedData getInstance() {
        if (instance == null) {
            throw new IllegalStateException("ChunkClaimsData is not initialized. Call initialize(ServerLevel) first.");
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    public static ServerLevel getServerInstance() {
        return serverLevelInstance;
    }

    public Optional<ClaimData> getClaim(String claimId) {
        return Optional.ofNullable(this.claims.get(claimId));
    }

    public Optional<ClaimData> getClaimByChunk(int chunkX, int chunkZ) {
        long cId = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
        return this.getClaimByChunk(cId);
    }

    public Optional<ClaimData> getClaimByChunk(long chunkId) {
        String claimId = this.chunkToClaimId.get(chunkId);
        if (claimId == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.claims.get(claimId));
    }

    public void addClaim(ClaimData claimData) {
        this.claims.put(claimData.getClaimId(), claimData);
        for (Long cid : claimData.getClaimedChunks()) {
            this.chunkToClaimId.put(cid, claimData.getClaimId());
        }
        this.m_77762_();
    }

    public void removeClaim(String claimId) {
        ClaimData removed = this.claims.remove(claimId);
        if (removed != null) {
            for (Long c : removed.getClaimedChunks()) {
                String stored = this.chunkToClaimId.get(c);
                if (!claimId.equals(stored)) continue;
                this.chunkToClaimId.remove(c);
            }
            this.m_77762_();
        }
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        ListTag chunkList = new ListTag();
        for (Map.Entry<Long, String> e : this.chunkToClaimId.entrySet()) {
            CompoundTag ct = new CompoundTag();
            ct.m_128356_("chunk_id", e.getKey().longValue());
            ct.m_128359_("claim_id", e.getValue());
            chunkList.add((Object)ct);
        }
        tag.m_128365_("chunks", (Tag)chunkList);
        CompoundTag claimsTag = new CompoundTag();
        for (Map.Entry<String, ClaimData> e : this.claims.entrySet()) {
            claimsTag.m_128365_(e.getKey(), (Tag)e.getValue().serializeNBT());
        }
        tag.m_128365_("claims", (Tag)claimsTag);
        return tag;
    }

    private void load(CompoundTag tag) {
        if (tag.m_128441_("chunks")) {
            ListTag chunkList = tag.m_128437_("chunks", 10);
            for (int i = 0; i < chunkList.size(); ++i) {
                CompoundTag ct = chunkList.m_128728_(i);
                long cId = ct.m_128454_("chunk_id");
                String claimId = ct.m_128461_("claim_id");
                this.chunkToClaimId.put(cId, claimId);
            }
        }
        if (tag.m_128441_("claims")) {
            CompoundTag claimsTag = tag.m_128469_("claims");
            for (String key : claimsTag.m_128431_()) {
                CompoundTag ctag = claimsTag.m_128469_(key);
                ClaimData cd = new ClaimData();
                cd.deserializeNBT(ctag);
                if (!cd.getClaimId().equals(key)) {
                    cd.setClaimId(key);
                }
                this.claims.put(key, cd);
            }
        }
    }
}

