/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.claim.chunk;

import java.util.HashSet;
import java.util.Set;
import net.mcreator.reignmod.claim.chunk.ClaimType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class ClaimData
implements INBTSerializable<CompoundTag> {
    private final Set<Long> claimedChunks = new HashSet<Long>();
    private String claimId;
    private String ownerId;
    private String ownerName;
    private ClaimType claimType;
    private int centerChunkX;
    private int centerChunkZ;

    public ClaimData() {
    }

    public ClaimData(String claimId, String ownerId, String ownerName, ClaimType claimType, int centerChunkX, int centerChunkZ) {
        this.claimId = claimId;
        this.ownerId = ownerId;
        this.ownerName = ownerName;
        this.claimType = claimType;
        this.centerChunkX = centerChunkX;
        this.centerChunkZ = centerChunkZ;
    }

    public String getClaimId() {
        return this.claimId;
    }

    public void setClaimId(String claimId) {
        this.claimId = claimId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public ClaimType getClaimType() {
        return this.claimType;
    }

    public void setClaimType(ClaimType claimType) {
        this.claimType = claimType;
    }

    public int getCenterChunkX() {
        return this.centerChunkX;
    }

    public void setCenterChunkX(int centerChunkX) {
        this.centerChunkX = centerChunkX;
    }

    public int getCenterChunkZ() {
        return this.centerChunkZ;
    }

    public void setCenterChunkZ(int centerChunkZ) {
        this.centerChunkZ = centerChunkZ;
    }

    public Set<Long> getClaimedChunks() {
        return this.claimedChunks;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("claim_id", this.claimId);
        tag.m_128359_("owner_id", this.ownerId);
        tag.m_128359_("owner_name", this.ownerName);
        tag.m_128359_("claim_type", this.claimType.name());
        tag.m_128405_("center_chunk_x", this.centerChunkX);
        tag.m_128405_("center_chunk_z", this.centerChunkZ);
        ListTag list = new ListTag();
        for (Long chunkId : this.claimedChunks) {
            list.add((Object)StringTag.m_129297_((String)chunkId.toString()));
        }
        tag.m_128365_("claimed_chunks", (Tag)list);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.claimId = tag.m_128461_("claim_id");
        this.ownerId = tag.m_128461_("owner_id");
        this.ownerName = tag.m_128461_("owner_name");
        this.claimType = ClaimType.valueOf(tag.m_128461_("claim_type"));
        this.centerChunkX = tag.m_128451_("center_chunk_x");
        this.centerChunkZ = tag.m_128451_("center_chunk_z");
        this.claimedChunks.clear();
        ListTag list = tag.m_128437_("claimed_chunks", 8);
        list.forEach(nbt -> {
            long cid = Long.parseLong(nbt.m_7916_());
            this.claimedChunks.add(cid);
        });
    }
}

